/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib.compatibilities;

import com.plotsquared.core.plot.Plot;
import io.th0rgal.protectionlib.ProtectionCompatibility;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlotSquaredCompat
extends ProtectionCompatibility {
    public PlotSquaredCompat(JavaPlugin mainPlugin, Plugin plugin) {
        super(mainPlugin, plugin);
    }

    @Override
    public boolean canBuild(Player player, Location target) {
        Plot plot = this.getPlotFromLocation(target);
        return plot == null || plot.isAdded(player.getUniqueId());
    }

    @Override
    public boolean canBreak(Player player, Location target) {
        Plot plot = this.getPlotFromLocation(target);
        return plot == null || !plot.isDenied(player.getUniqueId());
    }

    @Override
    public boolean canInteract(Player player, Location target) {
        Plot plot = this.getPlotFromLocation(target);
        return plot == null || plot.isAdded(player.getUniqueId());
    }

    @Override
    public boolean canUse(Player player, Location target) {
        Plot plot = this.getPlotFromLocation(target);
        return plot == null || plot.isAdded(player.getUniqueId());
    }

    private Plot getPlotFromLocation(Location location) {
        com.plotsquared.core.location.Location plotLoc = this.adaptBukkitLocation(location);
        if (plotLoc == null) {
            return null;
        }
        return Plot.getPlot((com.plotsquared.core.location.Location)plotLoc);
    }

    private com.plotsquared.core.location.Location adaptBukkitLocation(Location location) {
        if (!location.isWorldLoaded()) {
            return null;
        }
        assert (location.getWorld() != null);
        return com.plotsquared.core.location.Location.at((String)location.getWorld().getName(), (int)location.getBlockX(), (int)location.getBlockY(), (int)location.getBlockZ());
    }
}

