/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib.compatibilities;

import io.th0rgal.protectionlib.ProtectionCompatibility;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.type.Flags;
import me.angeschossen.lands.api.flags.type.RoleFlag;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.Land;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LandsCompat
extends ProtectionCompatibility {
    private static LandsIntegration landsIntegration;

    public LandsCompat(JavaPlugin mainPlugin, Plugin plugin) {
        super(mainPlugin, plugin);
        landsIntegration = LandsIntegration.of((Plugin)mainPlugin);
    }

    @Override
    public boolean canBuild(Player player, Location target) {
        Land land = this.getLand(target);
        return land == null || land.isTrusted(player.getUniqueId()) || this.hasFlag(target, player, Flags.BLOCK_PLACE);
    }

    @Override
    public boolean canBreak(Player player, Location target) {
        Land land = this.getLand(target);
        return land == null || land.isTrusted(player.getUniqueId()) || this.hasFlag(target, player, Flags.BLOCK_BREAK);
    }

    @Override
    public boolean canInteract(Player player, Location target) {
        Land land = this.getLand(target);
        return land == null || land.isTrusted(player.getUniqueId()) || this.hasFlag(target, player, Flags.INTERACT_GENERAL);
    }

    @Override
    public boolean canUse(Player player, Location target) {
        Land land = this.getLand(target);
        return land == null || land.isTrusted(player.getUniqueId()) || this.hasFlag(target, player, Flags.INTERACT_GENERAL);
    }

    private Land getLand(Location location) {
        Area area = landsIntegration.getArea(location);
        if (area == null) {
            return null;
        }
        return area.getLand();
    }

    private Area getArea(Location location) {
        return landsIntegration.getArea(location);
    }

    private boolean hasFlag(Location location, Player player, RoleFlag flag) {
        return this.getArea(location).hasRoleFlag(player.getUniqueId(), flag);
    }
}

