/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib;

import io.th0rgal.protectionlib.ProtectionCompatibility;
import io.th0rgal.protectionlib.compatibilities.BentoBoxCompat;
import io.th0rgal.protectionlib.compatibilities.CrashClaimCompat;
import io.th0rgal.protectionlib.compatibilities.FactionsUuidCompat;
import io.th0rgal.protectionlib.compatibilities.GriefPreventionCompat;
import io.th0rgal.protectionlib.compatibilities.HuskClaimCompat;
import io.th0rgal.protectionlib.compatibilities.LandsCompat;
import io.th0rgal.protectionlib.compatibilities.PlotSquaredCompat;
import io.th0rgal.protectionlib.compatibilities.TownyCompat;
import io.th0rgal.protectionlib.compatibilities.WorldGuardCompat;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ProtectionLib {
    private static final Set<ProtectionCompatibility> compatibilities = new HashSet<ProtectionCompatibility>();
    static boolean debug = false;

    public static void init(JavaPlugin plugin) {
        ProtectionLib.handleCompatibility("WorldGuard", plugin, (m, p) -> new WorldGuardCompat(m, p));
        ProtectionLib.handleCompatibility("Towny", plugin, (m, p) -> new TownyCompat(m, p));
        ProtectionLib.handleCompatibility("Factions", plugin, (m, p) -> new FactionsUuidCompat(m, p));
        ProtectionLib.handleCompatibility("Lands", plugin, (m, p) -> new LandsCompat(m, p));
        ProtectionLib.handleCompatibility("PlotSquared", plugin, (m, p) -> new PlotSquaredCompat(m, p));
        ProtectionLib.handleCompatibility("CrashClaim", plugin, (m, p) -> new CrashClaimCompat(m, p));
        ProtectionLib.handleCompatibility("GriefPrevention", plugin, (m, p) -> new GriefPreventionCompat(m, p));
        ProtectionLib.handleCompatibility("HuskClaims", plugin, (m, p) -> new HuskClaimCompat(m, p));
        ProtectionLib.handleCompatibility("BentoBox", plugin, (m, p) -> new BentoBoxCompat(m, p));
    }

    public static void setDebug(boolean debug) {
        ProtectionLib.debug = debug;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static boolean canBuild(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canBuild(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean canBreak(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canBreak(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean canInteract(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canInteract(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static boolean canUse(Player player, Location target) {
        try {
            return compatibilities.stream().allMatch(compatibility -> compatibility.canUse(player, target));
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static void handleCompatibility(String pluginName, JavaPlugin mainPlugin, CompatibilityConstructor constructor) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin != null) {
            if (pluginName.equals("Factions") && !ProtectionLib.checkFactionsCompat()) {
                return;
            }
            compatibilities.add(constructor.create(mainPlugin, plugin));
        }
    }

    private static boolean checkFactionsCompat() {
        try {
            Class.forName("com.massivecraft.factions.perms.PermissibleActions");
            return true;
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().warning("It seems a Factions plugin is installed, but it is not FactionsUUID.");
            Bukkit.getLogger().warning("ProtectionLib will not be able to handle Factions protection.");
            return false;
        }
    }

    @FunctionalInterface
    private static interface CompatibilityConstructor {
        public ProtectionCompatibility create(JavaPlugin var1, Plugin var2);
    }
}

