/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency.EfficiencyMechanicFactory;
import io.th0rgal.oraxen.packets.PacketAdapter;
import io.th0rgal.oraxen.packets.packetevents.InventoryPacketListener;
import io.th0rgal.oraxen.packets.packetevents.ScoreboardPacketListener;
import io.th0rgal.oraxen.packets.packetevents.TitlePacketListener;
import io.th0rgal.oraxen.packets.packetevents.mechanics.provided.gameplay.efficiency.EfficiencyMechanicListener;
import io.th0rgal.oraxen.utils.SnapshotVersion;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PacketEventsAdapter
implements PacketAdapter {
    private PacketListenerCommon scoreboardPacketListener;
    private PacketListenerCommon titlePacketListener;
    private PacketListenerCommon inventoryPacketListener;
    private PacketListenerCommon efficiencyMechanicListener;

    @Override
    public boolean isEnabled() {
        return PacketAdapter.isPacketEventsEnabled();
    }

    @Override
    public void registerInventoryListener() {
        if (this.inventoryPacketListener != null) {
            OraxenPlugin.get().getLogger().severe("[PacketEventsAdapter]: Inventory Listener is already registered!");
            return;
        }
        this.inventoryPacketListener = this.register(new InventoryPacketListener(), PacketListenerPriority.MONITOR);
    }

    @Override
    public void registerScoreboardListener() {
        if (this.scoreboardPacketListener != null) {
            OraxenPlugin.get().getLogger().severe("[PacketEventsAdapter]: Scoreboard Listener is already registered!");
            return;
        }
        this.scoreboardPacketListener = this.register(new ScoreboardPacketListener(), PacketListenerPriority.MONITOR);
    }

    @Override
    public void registerTitleListener() {
        if (this.titlePacketListener != null) {
            OraxenPlugin.get().getLogger().severe("[PacketEventsAdapter]: Title Listener is already registered!");
            return;
        }
        this.titlePacketListener = this.register(new TitlePacketListener(), PacketListenerPriority.MONITOR);
    }

    @Override
    public void removeInventoryListener() {
        if (this.inventoryPacketListener != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener(this.inventoryPacketListener);
        }
        this.inventoryPacketListener = null;
    }

    @Override
    public void removeTitleListener() {
        if (this.titlePacketListener != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener(this.titlePacketListener);
        }
        this.titlePacketListener = null;
    }

    @Override
    public void reregisterEfficencyMechanicListener(EfficiencyMechanicFactory efficiencyMechanicFactory) {
        if (this.efficiencyMechanicListener != null) {
            PacketEvents.getAPI().getEventManager().unregisterListener(this.efficiencyMechanicListener);
        }
        this.efficiencyMechanicListener = this.register(new EfficiencyMechanicListener(efficiencyMechanicFactory), PacketListenerPriority.LOW);
    }

    @Override
    public String getLatestMCVersion() {
        return ServerVersion.getLatest().getReleaseName();
    }

    @Override
    public boolean isNewer(SnapshotVersion snapshot) {
        return true;
    }

    @Override
    @Nullable
    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin("PacketEvents");
    }

    private PacketListenerCommon register(PacketListener listener, PacketListenerPriority priority) {
        return PacketEvents.getAPI().getEventManager().registerListener(listener, priority);
    }
}

