/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureSoundListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureUpdater;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.evolution.EvolutionListener;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.evolution.EvolutionTask;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.jukebox.JukeboxListener;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class FurnitureFactory
extends MechanicFactory {
    public static FurnitureMechanic.FurnitureType defaultFurnitureType;
    public static FurnitureFactory instance;
    public final List<String> toolTypes;
    public final int evolutionCheckDelay;
    private boolean evolvingFurnitures;
    private static EvolutionTask evolutionTask;
    public final boolean customSounds;
    public final boolean detectViabackwards;

    public FurnitureFactory(ConfigurationSection section) {
        super(section);
        defaultFurnitureType = OraxenPlugin.supportsDisplayEntities ? FurnitureMechanic.FurnitureType.getType(section.getString("default_furniture_type", "DISPLAY_ENTITY")) : FurnitureMechanic.FurnitureType.ITEM_FRAME;
        this.toolTypes = section.getStringList("tool_types");
        this.evolutionCheckDelay = section.getInt("evolution_check_delay");
        MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new FurnitureListener(), new FurnitureUpdater(), new EvolutionListener(), new JukeboxListener());
        this.evolvingFurnitures = false;
        instance = this;
        this.customSounds = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("custom_block_sounds").getBoolean("stringblock_and_furniture", true);
        if (this.customSounds) {
            MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new FurnitureSoundListener());
        }
        this.detectViabackwards = OraxenPlugin.get().getConfigsManager().getMechanics().getConfigurationSection("furniture").getBoolean("detect_viabackwards", true);
    }

    public static boolean setDefaultType(ConfigurationSection mechanicSection) {
        if (mechanicSection.isSet("type")) {
            return true;
        }
        mechanicSection.set("type", (Object)defaultFurnitureType.toString());
        return false;
    }

    @Override
    public Mechanic parse(ConfigurationSection itemMechanicConfiguration) {
        FurnitureMechanic mechanic = new FurnitureMechanic(this, itemMechanicConfiguration);
        this.addToImplemented(mechanic);
        return mechanic;
    }

    public static boolean isEnabled() {
        return instance != null;
    }

    public static FurnitureFactory getInstance() {
        return instance;
    }

    public static EvolutionTask getEvolutionTask() {
        return evolutionTask;
    }

    public void registerEvolution() {
        if (this.evolvingFurnitures) {
            return;
        }
        if (evolutionTask != null) {
            evolutionTask.cancel();
        }
        evolutionTask = new EvolutionTask(this, this.evolutionCheckDelay);
        BukkitTask task = evolutionTask.runTaskTimer((Plugin)OraxenPlugin.get(), 0L, this.evolutionCheckDelay);
        MechanicsManager.registerTask(this.getMechanicID(), task);
        this.evolvingFurnitures = true;
    }

    public static void unregisterEvolution() {
        if (evolutionTask != null) {
            evolutionTask.cancel();
        }
    }

    @Override
    public FurnitureMechanic getMechanic(String itemID) {
        return (FurnitureMechanic)super.getMechanic(itemID);
    }

    @Override
    public FurnitureMechanic getMechanic(ItemStack itemStack) {
        return (FurnitureMechanic)super.getMechanic(itemStack);
    }
}

