/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.breaker;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProtocolLibBreakerSystem
extends BreakerSystem {
    private final PacketAdapter listener = new PacketAdapter((Plugin)OraxenPlugin.get(), ListenerPriority.LOW, new PacketType[]{PacketType.Play.Client.BLOCK_DIG}){

        public void onPacketReceiving(PacketEvent event) {
            EnumWrappers.PlayerDigType type;
            PacketContainer packet = event.getPacket();
            Player player = event.getPlayer();
            ItemStack item = player.getInventory().getItemInMainHand();
            if (player.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            StructureModifier dataTemp = packet.getBlockPositionModifier();
            StructureModifier dataDirection = packet.getDirections();
            StructureModifier data = packet.getEnumModifier(EnumWrappers.PlayerDigType.class, 2);
            try {
                type = (EnumWrappers.PlayerDigType)data.getValues().getFirst();
            }
            catch (IllegalArgumentException exception) {
                type = EnumWrappers.PlayerDigType.SWAP_HELD_ITEMS;
            }
            BlockPosition pos = (BlockPosition)dataTemp.getValues().getFirst();
            World world = player.getWorld();
            Block block = world.getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            Location location = block.getLocation();
            BlockFace blockFace = dataDirection.size() > 0 ? BlockFace.valueOf((String)((EnumWrappers.Direction)dataDirection.read(0)).name()) : BlockFace.UP;
            ProtocolLibBreakerSystem.this.handleEvent(player, block, location, blockFace, world, () -> event.setCancelled(true), type == EnumWrappers.PlayerDigType.START_DESTROY_BLOCK);
        }
    };

    @Override
    protected void sendBlockBreak(Player player, Location location, int stage) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.BLOCK_BREAK_ANIMATION);
        packet.getIntegers().write(0, (Object)location.hashCode()).write(1, (Object)stage);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(location.toVector()));
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet);
    }

    @Override
    public void registerListener() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.listener);
    }
}

