/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_4_5;

import com.github.stefvanschie.inventoryframework.abstraction.MerchantInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_4_5.util.TextHolderUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerMerchant;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.IMerchant;
import net.minecraft.server.v1_16_R3.ITileInventory;
import net.minecraft.server.v1_16_R3.InventoryMerchant;
import net.minecraft.server.v1_16_R3.MerchantRecipe;
import net.minecraft.server.v1_16_R3.MerchantRecipeList;
import net.minecraft.server.v1_16_R3.MerchantWrapper;
import net.minecraft.server.v1_16_R3.PlayerInventory;
import net.minecraft.server.v1_16_R3.Slot;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryMerchant;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MerchantInventoryImpl
extends MerchantInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(@NotNull TextHolder title) {
        MerchantWrapper merchant = new MerchantWrapper(null);
        final InventoryViewProvider container = new InventoryViewProvider((IMerchant)merchant, (IMerchant)merchant, title){
            final /* synthetic */ IMerchant val$merchant;
            final /* synthetic */ TextHolder val$title;
            {
                this.val$merchant = iMerchant;
                this.val$title = textHolder;
                super(merchant);
            }

            @NotNull
            @Contract(pure=true)
            public Container createMenu(int containerId, @Nullable PlayerInventory inventory, @NotNull EntityHuman player) {
                return new ContainerMerchantImpl(containerId, player, this, this.val$merchant);
            }

            @NotNull
            @Contract(pure=true)
            public IChatBaseComponent getScoreboardDisplayName() {
                return TextHolderUtil.toComponent(this.val$title);
            }
        };
        return new CraftInventoryMerchant((IMerchant)merchant, container){

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.MERCHANT;
            }

            public InventoryMerchant getInventory() {
                return container;
            }
        };
    }

    @Override
    public void sendMerchantOffers(@NotNull Player player, @NotNull List<? extends Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer>> trades, int level, int experience) {
        MerchantRecipeList offers = new MerchantRecipeList();
        for (Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer> entry : trades) {
            org.bukkit.inventory.MerchantRecipe recipe = entry.getKey();
            List ingredients = recipe.getIngredients();
            if (ingredients.size() < 1) {
                throw new IllegalStateException("Merchant recipe has no ingredients");
            }
            ItemStack itemA = (ItemStack)ingredients.get(0);
            ItemStack itemB = null;
            if (ingredients.size() >= 2) {
                itemB = (ItemStack)ingredients.get(1);
            }
            net.minecraft.server.v1_16_R3.ItemStack nmsItemA = CraftItemStack.asNMSCopy((ItemStack)itemA);
            net.minecraft.server.v1_16_R3.ItemStack nmsItemB = net.minecraft.server.v1_16_R3.ItemStack.b;
            net.minecraft.server.v1_16_R3.ItemStack nmsItemResult = CraftItemStack.asNMSCopy((ItemStack)recipe.getResult());
            if (itemB != null) {
                nmsItemB = CraftItemStack.asNMSCopy((ItemStack)itemB);
            }
            int uses = recipe.getUses();
            int maxUses = recipe.getMaxUses();
            int exp = recipe.getVillagerExperience();
            float multiplier = recipe.getPriceMultiplier();
            MerchantRecipe merchantOffer = new MerchantRecipe(nmsItemA, nmsItemB, nmsItemResult, uses, maxUses, exp, multiplier);
            merchantOffer.setSpecialPrice(entry.getValue().intValue());
            offers.add((Object)merchantOffer);
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        entityPlayer.openTrade(this.getWindowId(entityPlayer), offers, level, experience, true, false);
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    private static class ContainerMerchantImpl
    extends ContainerMerchant {
        @NotNull
        private final HumanEntity humanEntity;
        @NotNull
        private final InventoryMerchant container;
        @NotNull
        private final IMerchant merchant;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerMerchantImpl(int containerId, @NotNull EntityHuman player, @NotNull InventoryMerchant container, @NotNull IMerchant merchant) {
            super(containerId, player.inventory, merchant);
            this.humanEntity = player.getBukkitEntity();
            this.container = container;
            this.merchant = merchant;
            this.checkReachable = false;
            this.updateSlot(0, (IInventory)container);
            this.updateSlot(1, (IInventory)container);
            Slot slot = (Slot)this.slots.get(2);
            Slot newSlot = new Slot((IInventory)container, slot.index, slot.e, slot.f){

                @Contract(value="_ -> false", pure=true)
                public boolean isAllowed(@Nullable EntityHuman player) {
                    return false;
                }

                @Contract(value="_ -> false", pure=true)
                public boolean isAllowed(@Nullable net.minecraft.server.v1_16_R3.ItemStack itemStack) {
                    return false;
                }
            };
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(2, newSlot);
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryMerchant inventory = new CraftInventoryMerchant(this.merchant, this.container);
            this.bukkitEntity = new CraftInventoryView(this.humanEntity, (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        public void a(@Nullable IInventory container) {
        }

        public void b(@Nullable EntityHuman player) {
        }

        protected void a(@Nullable EntityHuman player, @Nullable World world, @Nullable IInventory container) {
        }

        public void d(int i) {
        }

        public void g(int i) {
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.slots.get(slotIndex);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(slotIndex, newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends InventoryMerchant
    implements ITileInventory {
        public InventoryViewProvider(@NotNull IMerchant merchant) {
            super(merchant);
        }
    }
}

