/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.food;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.ecoitems.WrappedEcoItem;
import io.th0rgal.oraxen.compatibilities.provided.mythiccrucible.WrappedCrucibleItem;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.PotionUtils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.Indyuce.mmoitems.MMOItems;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@Deprecated(forRemoval=true, since="1.20.6")
public class FoodMechanic
extends Mechanic {
    private final Set<PotionEffect> effects = new HashSet<PotionEffect>();
    private final double effectProbability;
    private final int hunger;
    private final int saturation;
    private ItemStack replacementItem;

    public FoodMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        this.hunger = section.getInt("hunger");
        this.saturation = section.getInt("saturation");
        this.effectProbability = Math.min(section.getDouble("effect_probability", 1.0), 1.0);
        this.replacementItem = section.isConfigurationSection("replacement") ? new ItemStack(Material.AIR) : null;
        ConfigurationSection effectsSection = section.getConfigurationSection("effects");
        if (effectsSection != null) {
            for (String effect : effectsSection.getKeys(false)) {
                ConfigurationSection effectSection = effectsSection.getConfigurationSection(effect);
                if (effectSection == null) continue;
                this.registerEffects(effectSection);
            }
        }
    }

    private void registerEffects(ConfigurationSection section) {
        String type = section.getName().toLowerCase(Locale.ROOT);
        PotionEffectType effectType = PotionUtils.getEffectType(type);
        if (effectType == null) {
            Logs.logError("Invalid potion effect: " + section.getName() + ", in " + StringUtils.substringBefore((String)section.getCurrentPath(), (String)".") + "!");
            return;
        }
        this.effects.add(new PotionEffect(effectType, section.getInt("duration", 1) * 20, section.getInt("amplifier", 0), section.getBoolean("is_ambient", true), section.getBoolean("has_particles", true), section.getBoolean("has_icon", true)));
    }

    public void registerReplacement(ConfigurationSection section) {
        if (section.isString("minecraft_type")) {
            Material material = Material.getMaterial((String)Objects.requireNonNull(section.getString("minecraft_type")));
            if (material == null) {
                Message.INVALID_MATERIAL.log(AdventureUtils.tagResolver("minecraft_type", section.getString("minecraft_type")));
                this.replacementItem = null;
            } else {
                this.replacementItem = new ItemStack(material);
            }
        } else {
            this.replacementItem = section.isString("oraxen_item") ? OraxenItems.getItemById(section.getString("oraxen_item")).build() : (section.isString("crucible_item") ? new WrappedCrucibleItem(section.getString("crucible_item")).build() : (section.isString("mmoitems_id") && section.isString("mmoitems_type") ? MMOItems.plugin.getItem(section.getString("mmoitems_type"), section.getString("mmoitems_id")) : (section.isString("ecoitem_id") ? new WrappedEcoItem(section.getString("ecoitem_id")).build() : null)));
        }
    }

    public int getHunger() {
        return this.hunger;
    }

    public int getSaturation() {
        return this.saturation;
    }

    public boolean hasReplacement() {
        return this.replacementItem != null;
    }

    public ItemStack getReplacement() {
        return this.replacementItem;
    }

    public boolean hasEffects() {
        return !this.effects.isEmpty();
    }

    public Set<PotionEffect> getEffects() {
        return this.effects;
    }

    public double getEffectProbability() {
        return this.effectProbability;
    }
}

