/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.compatibilities.provided.worldedit;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.eventbus.Subscribe;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;
import org.enginehub.linbus.tree.LinCompoundTag;
import org.enginehub.linbus.tree.LinStringTag;
import org.enginehub.linbus.tree.LinTag;
import org.enginehub.linbus.tree.LinTagType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldEditHandlers {
    private static final List<com.sk89q.worldedit.world.entity.EntityType> furnitureTypes = new ArrayList<com.sk89q.worldedit.world.entity.EntityType>();

    public WorldEditHandlers(boolean register) {
        if (register) {
            WorldEdit.getInstance().getEventBus().register((Object)this);
        } else {
            WorldEdit.getInstance().getEventBus().unregister((Object)this);
        }
    }

    @Subscribe
    public void onEditSession(final EditSessionEvent event) {
        if (event.getWorld() == null) {
            return;
        }
        event.setExtent((Extent)new AbstractDelegateExtent(this, event.getExtent()){

            public Entity createEntity(com.sk89q.worldedit.util.Location location, BaseEntity baseEntity) {
                if (!Settings.WORLDEDIT_FURNITURE.toBool().booleanValue()) {
                    return super.createEntity(location, baseEntity);
                }
                if (baseEntity == null || baseEntity.getType() == BukkitAdapter.adapt((EntityType)EntityType.INTERACTION)) {
                    return null;
                }
                if (!furnitureTypes.contains(baseEntity.getType())) {
                    return super.createEntity(location, baseEntity);
                }
                Location bukkitLocation = BukkitAdapter.adapt((org.bukkit.World)BukkitAdapter.adapt((World)event.getWorld()), (com.sk89q.worldedit.util.Location)location);
                FurnitureMechanic mechanic = WorldEditHandlers.getFurnitureMechanic(baseEntity);
                if (mechanic == null) {
                    return super.createEntity(location, baseEntity);
                }
                LinCompoundTag compoundTag = baseEntity.getNbt();
                if (compoundTag == null) {
                    return super.createEntity(location, baseEntity);
                }
                LinCompoundTag bukkitValues = (LinCompoundTag)compoundTag.getTag("BukkitValues", LinTagType.compoundTag());
                if (bukkitValues != null) {
                    bukkitValues.toBuilder().remove("oraxen:interaction").build();
                    compoundTag = compoundTag.toBuilder().put("BukkitValues", (LinTag)bukkitValues).build();
                    baseEntity.setNbt(compoundTag);
                }
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OraxenPlugin.get(), () -> {
                    EntityType type = BukkitAdapter.adapt((com.sk89q.worldedit.world.entity.EntityType)baseEntity.getType());
                    bukkitLocation.getNearbyEntities(0.5, 0.5, 0.5).stream().filter(e -> e.getType().equals((Object)type)).min(Comparator.comparingDouble(entity -> entity.getLocation().distanceSquared(bukkitLocation))).ifPresent(e -> mechanic.setEntityData((org.bukkit.entity.Entity)e, e.getLocation().getYaw(), BlockFace.NORTH));
                }, 5L);
                return super.createEntity(location, baseEntity);
            }

            public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 pos, T block) throws WorldEditException {
                BlockData blockData = BukkitAdapter.adapt(block);
                org.bukkit.World world = BukkitAdapter.adapt((World)event.getWorld());
                Location loc = BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)pos);
                Mechanic mechanic = OraxenBlocks.getOraxenBlock(blockData);
                if (blockData.getMaterial() == Material.NOTE_BLOCK) {
                    if (mechanic != null && Settings.WORLDEDIT_NOTEBLOCKS.toBool().booleanValue()) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OraxenPlugin.get(), () -> OraxenBlocks.place(mechanic.getItemID(), loc), 1L);
                    }
                } else if (blockData.getMaterial() == Material.TRIPWIRE) {
                    if (mechanic != null && Settings.WORLDEDIT_STRINGBLOCKS.toBool().booleanValue()) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OraxenPlugin.get(), () -> OraxenBlocks.place(mechanic.getItemID(), loc), 1L);
                    }
                } else {
                    if (world == null) {
                        return super.setBlock(pos, block);
                    }
                    Mechanic replacingMechanic = OraxenBlocks.getOraxenBlock(loc);
                    if (replacingMechanic == null) {
                        return super.setBlock(pos, block);
                    }
                    if (replacingMechanic instanceof StringBlockMechanic && !Settings.WORLDEDIT_STRINGBLOCKS.toBool().booleanValue()) {
                        return super.setBlock(pos, block);
                    }
                    if (replacingMechanic instanceof NoteBlockMechanic && !Settings.WORLDEDIT_NOTEBLOCKS.toBool().booleanValue()) {
                        return super.setBlock(pos, block);
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OraxenPlugin.get(), () -> OraxenBlocks.remove(loc, null), 1L);
                }
                return super.setBlock(pos, block);
            }
        });
    }

    @Nullable
    private static FurnitureMechanic getFurnitureMechanic(@NotNull BaseEntity entity) {
        if (!furnitureTypes.contains(entity.getType())) {
            return null;
        }
        LinCompoundTag tag = entity.getNbt();
        if (tag == null) {
            return null;
        }
        LinCompoundTag bukkitValues = (LinCompoundTag)tag.getTag("BukkitValues", LinTagType.compoundTag());
        if (bukkitValues == null) {
            return null;
        }
        LinStringTag furnitureTag = (LinStringTag)bukkitValues.getTag("oraxen:furniture", LinTagType.stringTag());
        if (furnitureTag == null) {
            return null;
        }
        String furnitureId = furnitureTag.value();
        return OraxenFurniture.getFurnitureMechanic(furnitureId);
    }

    static {
        furnitureTypes.add(BukkitAdapter.adapt((EntityType)EntityType.ITEM_FRAME));
        if (VersionUtil.atOrAbove("1.19.4")) {
            furnitureTypes.add(BukkitAdapter.adapt((EntityType)EntityType.ITEM_DISPLAY));
            furnitureTypes.add(BukkitAdapter.adapt((EntityType)EntityType.INTERACTION));
        }
    }
}

