/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.blocksounds;

import io.th0rgal.oraxen.utils.BlockHelpers;
import org.bukkit.configuration.ConfigurationSection;

public class BlockSounds {
    public static String VANILLA_STONE_PLACE = "minecraft:required.stone.place";
    public static String VANILLA_STONE_BREAK = "minecraft:required.stone.break";
    public static String VANILLA_STONE_HIT = "minecraft:required.stone.hit";
    public static String VANILLA_STONE_STEP = "minecraft:required.stone.step";
    public static String VANILLA_STONE_FALL = "minecraft:required.stone.fall";
    public static String VANILLA_WOOD_PLACE = "minecraft:required.wood.place";
    public static String VANILLA_WOOD_BREAK = "minecraft:required.wood.break";
    public static String VANILLA_WOOD_HIT = "minecraft:required.wood.hit";
    public static String VANILLA_WOOD_STEP = "minecraft:required.wood.step";
    public static String VANILLA_WOOD_FALL = "minecraft:required.wood.fall";
    public static float VANILLA_PLACE_VOLUME = 1.0f;
    public static float VANILLA_PLACE_PITCH = 0.8f;
    public static float VANILLA_BREAK_VOLUME = 1.0f;
    public static float VANILLA_BREAK_PITCH = 0.8f;
    public static float VANILLA_HIT_VOLUME = 0.25f;
    public static float VANILLA_HIT_PITCH = 0.5f;
    public static float VANILLA_STEP_VOLUME = 0.15f;
    public static float VANILLA_STEP_PITCH = 1.0f;
    public static float VANILLA_FALL_VOLUME = 0.5f;
    public static float VANILLA_FALL_PITCH = 0.75f;
    private final String placeSound;
    private final String breakSound;
    private final String stepSound;
    private final String hitSound;
    private final String fallSound;
    private final float placeVolume;
    private final float breakVolume;
    private final float stepVolume;
    private final float hitVolume;
    private final float fallVolume;
    private final float placePitch;
    private final float breakPitch;
    private final float stepPitch;
    private final float hitPitch;
    private final float fallPitch;

    public BlockSounds(ConfigurationSection section) {
        this.placeSound = this.getSound(section, "place");
        this.breakSound = this.getSound(section, "break");
        this.stepSound = this.getSound(section, "step");
        this.hitSound = this.getSound(section, "hit");
        this.fallSound = this.getSound(section, "fall");
        this.placeVolume = this.getVolume(section, "place", VANILLA_PLACE_VOLUME);
        this.breakVolume = this.getVolume(section, "break", VANILLA_BREAK_VOLUME);
        this.stepVolume = this.getVolume(section, "step", VANILLA_STEP_VOLUME);
        this.hitVolume = this.getVolume(section, "hit", VANILLA_HIT_VOLUME);
        this.fallVolume = this.getVolume(section, "fall", VANILLA_FALL_VOLUME);
        this.placePitch = this.getPitch(section, "place", VANILLA_PLACE_PITCH);
        this.breakPitch = this.getPitch(section, "break", VANILLA_BREAK_PITCH);
        this.stepPitch = this.getPitch(section, "step", VANILLA_STEP_PITCH);
        this.hitPitch = this.getPitch(section, "hit", VANILLA_HIT_PITCH);
        this.fallPitch = this.getPitch(section, "fall", VANILLA_FALL_PITCH);
    }

    private String getSound(ConfigurationSection section, String key) {
        ConfigurationSection soundSection = section.getConfigurationSection(key);
        return section.isString(key + "_sound") ? section.getString(key + "_sound") : (soundSection != null ? soundSection.getString("sound") : null);
    }

    private float getVolume(ConfigurationSection section, String type, float defaultValue) {
        ConfigurationSection soundSection = section.getConfigurationSection(type);
        if (soundSection == null) {
            return (float)section.getDouble("volume", (double)defaultValue);
        }
        return defaultValue;
    }

    private float getPitch(ConfigurationSection section, String type, float defaultValue) {
        ConfigurationSection soundSection = section.getConfigurationSection(type);
        if (soundSection != null) {
            return (float)soundSection.getDouble("pitch", (double)defaultValue);
        }
        return defaultValue;
    }

    public boolean hasPlaceSound() {
        return this.placeSound != null;
    }

    public String getPlaceSound() {
        return BlockHelpers.validateReplacedSounds(this.placeSound);
    }

    public boolean hasBreakSound() {
        return this.breakSound != null;
    }

    public String getBreakSound() {
        return BlockHelpers.validateReplacedSounds(this.breakSound);
    }

    public boolean hasStepSound() {
        return this.stepSound != null;
    }

    public String getStepSound() {
        return BlockHelpers.validateReplacedSounds(this.stepSound);
    }

    public boolean hasHitSound() {
        return this.hitSound != null;
    }

    public String getHitSound() {
        return BlockHelpers.validateReplacedSounds(this.hitSound);
    }

    public boolean hasFallSound() {
        return this.fallSound != null;
    }

    public String getFallSound() {
        return BlockHelpers.validateReplacedSounds(this.fallSound);
    }

    public float getPlaceVolume() {
        return this.placeVolume;
    }

    public float getBreakVolume() {
        return this.breakVolume;
    }

    public float getStepVolume() {
        return this.stepVolume;
    }

    public float getHitVolume() {
        return this.hitVolume;
    }

    public float getFallVolume() {
        return this.fallVolume;
    }

    public float getPlacePitch() {
        return this.placePitch;
    }

    public float getBreakPitch() {
        return this.breakPitch;
    }

    public float getStepPitch() {
        return this.stepPitch;
    }

    public float getHitPitch() {
        return this.hitPitch;
    }

    public float getFallPitch() {
        return this.fallPitch;
    }
}

