/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.evolution;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.evolution.EvolvingFurniture;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.farmblock.FarmBlockDryout;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.scheduler.BukkitRunnable;

public class EvolutionTask
extends BukkitRunnable {
    private final FurnitureFactory furnitureFactory;
    private final int delay;

    public EvolutionTask(FurnitureFactory furnitureFactory, int delay) {
        this.furnitureFactory = furnitureFactory;
        this.delay = delay;
    }

    public void run() {
        for (World world : Bukkit.getWorlds()) {
            for (Class<? extends Entity> entityClass : FurnitureMechanic.FurnitureType.furnitureEntityClasses()) {
                for (Entity entity : world.getEntitiesByClass(entityClass)) {
                    int evolutionStep;
                    EvolvingFurniture evolution;
                    Location entityLoc = entity.getLocation();
                    PersistentDataContainer pdc = entity.getPersistentDataContainer();
                    if (!pdc.has(FurnitureMechanic.EVOLUTION_KEY, PersistentDataType.INTEGER)) continue;
                    Block blockBelow = entityLoc.getBlock().getRelative(BlockFace.DOWN);
                    FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
                    if (mechanic == null) continue;
                    if (mechanic.farmlandRequired && blockBelow.getType() != Material.FARMLAND) {
                        OraxenFurniture.remove(entity, null);
                        continue;
                    }
                    if (mechanic.farmblockRequired) {
                        NoteBlockMechanic noteMechanic = OraxenBlocks.getNoteBlockMechanic(blockBelow);
                        if (noteMechanic == null || !noteMechanic.hasDryout()) {
                            OraxenFurniture.remove(entity, null);
                            continue;
                        }
                        FarmBlockDryout dryoutMechanic = noteMechanic.getDryout();
                        if (!dryoutMechanic.isFarmBlock()) {
                            OraxenFurniture.remove(entity, null);
                            continue;
                        }
                        if (!dryoutMechanic.isMoistFarmBlock()) {
                            pdc.set(FurnitureMechanic.EVOLUTION_KEY, PersistentDataType.INTEGER, (Object)0);
                            continue;
                        }
                    }
                    if ((evolution = mechanic.getEvolution()) == null) continue;
                    int lightBoostTick = 0;
                    int rainBoostTick = 0;
                    if (evolution.isLightBoosted() && entityLoc.getBlock().getLightLevel() >= evolution.getMinimumLightLevel()) {
                        lightBoostTick = evolution.getLightBoostTick();
                    }
                    if (evolution.isRainBoosted() && world.hasStorm() && (double)world.getHighestBlockAt(entityLoc).getY() > entityLoc.getY()) {
                        rainBoostTick = evolution.getRainBoostTick();
                    }
                    if ((evolutionStep = (Integer)pdc.get(FurnitureMechanic.EVOLUTION_KEY, PersistentDataType.INTEGER) + this.delay + lightBoostTick + rainBoostTick) > evolution.getDelay()) {
                        FurnitureMechanic nextMechanic;
                        if (evolution.getNextStage() == null || !evolution.bernoulliTest() || (nextMechanic = this.furnitureFactory.getMechanic(evolution.getNextStage())) == null) continue;
                        OraxenFurniture.remove(entity, null);
                        nextMechanic.place(entity.getLocation(), Float.valueOf(entity.getLocation().getYaw()), entity.getFacing());
                        continue;
                    }
                    pdc.set(FurnitureMechanic.EVOLUTION_KEY, PersistentDataType.INTEGER, (Object)evolutionStep);
                }
            }
        }
    }
}

