/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.bukkit.Material;

public class ItemModelGenerator {
    public static JsonObject generateModel(String parentModel, String texturePath, Material material) {
        JsonObject modelJson = new JsonObject();
        modelJson.addProperty("parent", parentModel);
        JsonObject textureJson = new JsonObject();
        textureJson.addProperty("layer0", texturePath);
        modelJson.add("textures", (JsonElement)textureJson);
        if (ItemModelGenerator.needsTinting(material)) {
            modelJson.add("tints", (JsonElement)ItemModelGenerator.createTintArray(material));
        }
        return modelJson;
    }

    private static JsonArray createTintArray(Material material) {
        JsonArray tints = new JsonArray();
        if (material.name().startsWith("LEATHER_")) {
            JsonObject dyeTint = new JsonObject();
            dyeTint.addProperty("type", "minecraft:dye");
            dyeTint.addProperty("default", (Number)10511680);
            tints.add((JsonElement)dyeTint);
        } else if (material == Material.POTION || material == Material.SPLASH_POTION || material == Material.LINGERING_POTION) {
            JsonObject potionTint = new JsonObject();
            potionTint.addProperty("type", "minecraft:potion");
            potionTint.addProperty("default", (Number)0xF800F8);
            tints.add((JsonElement)potionTint);
        }
        return tints;
    }

    private static boolean needsTinting(Material material) {
        return material.name().startsWith("LEATHER_") || material == Material.POTION || material == Material.SPLASH_POTION || material == Material.LINGERING_POTION;
    }
}

