/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.gabytm.util.actions.actions.Action;
import me.gabytm.util.actions.actions.ActionManager;
import me.gabytm.util.actions.actions.ActionMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionParser {
    private static final Pattern ACTION_PATTERN = Pattern.compile("(?:\\{(?<properties>.+)}[^\\[]*)?(?:\\[(?<id>\\w+)])\\s?(?<data>.*)?");
    private final ActionManager actionManager;

    public ActionParser(ActionManager actionManager) {
        this.actionManager = actionManager;
    }

    @NotNull
    private Map<String, String> parseProperties(@NotNull Matcher matcher) {
        String propertiesGroup = matcher.group("properties");
        if (propertiesGroup == null || propertiesGroup.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String part : propertiesGroup.split(" ")) {
            String[] property = part.split("=", 2);
            if (property.length != 2) continue;
            properties.put(property[0], property[1]);
        }
        return properties;
    }

    @Nullable
    public <T> Action<T> parseAction(@NotNull Class<T> clazz, @NotNull String input) {
        Matcher matcher = ACTION_PATTERN.matcher(input);
        if (!matcher.find()) {
            return null;
        }
        String id = matcher.group("id");
        if (!this.actionManager.isRegistered(clazz, id)) {
            return null;
        }
        String data = matcher.group("data");
        List nodes = data == null ? Collections.emptyList() : this.actionManager.getComponentParser().parseComponents(clazz, data);
        ActionMeta meta = new ActionMeta(this.parseProperties(matcher), data, nodes);
        return this.actionManager.createAction(clazz, id, meta);
    }
}

