/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import javax.annotation.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionUtils {
    public static PotionEffectType getEffectType(String effect) {
        return PotionUtils.getEffectType(effect, null);
    }

    @Nullable
    public static PotionEffectType getEffectType(String effect, String legacyEffect) {
        if (effect == null || effect.isEmpty()) {
            return null;
        }
        PotionEffectType effectType = null;
        try {
            if (VersionUtil.isPaperServer()) {
                effectType = (PotionEffectType)Registry.POTION_EFFECT_TYPE.get(NamespacedKey.fromString((String)effect.toLowerCase()));
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        if (effectType == null) {
            effectType = PotionEffectType.getByName((String)effect);
        }
        if (effectType == null) {
            effectType = PotionEffectType.getByKey((NamespacedKey)(effect.contains(":") ? NamespacedKey.fromString((String)effect) : NamespacedKey.minecraft((String)effect)));
        }
        if (effectType == null && legacyEffect != null && !legacyEffect.isEmpty()) {
            effectType = PotionUtils.getEffectType(legacyEffect, null);
        }
        if (effectType == null) {
            Logs.logWarning("Invalid PotionEffectType: " + effect);
        }
        return effectType;
    }

    public static PotionType getPotionType(PotionMeta potionMeta) {
        if (VersionUtil.atOrAbove("1.20.2")) {
            return potionMeta.getBasePotionType();
        }
        return potionMeta.getBasePotionData().getType();
    }

    public static void setPotionType(PotionMeta potionMeta, PotionType potionType) {
        if (VersionUtil.atOrAbove("1.20.2")) {
            potionMeta.setBasePotionType(potionType);
        } else {
            potionMeta.setBasePotionData(new PotionData(potionType));
        }
    }
}

