/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.packets;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency.EfficiencyMechanicFactory;
import io.th0rgal.oraxen.packets.PacketAdapter;
import io.th0rgal.oraxen.packets.protocollib.InventoryPacketListener;
import io.th0rgal.oraxen.packets.protocollib.ScoreboardPacketListener;
import io.th0rgal.oraxen.packets.protocollib.TitlePacketListener;
import io.th0rgal.oraxen.packets.protocollib.mechanics.provided.gameplay.efficiency.EfficiencyMechanicListener;
import io.th0rgal.oraxen.utils.SnapshotVersion;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ProtocolLibAdapter
implements PacketAdapter {
    private ScoreboardPacketListener scoreboardPacketListener;
    private InventoryPacketListener inventoryPacketListener;
    private TitlePacketListener titlePacketListener;
    private EfficiencyMechanicListener efficiencyMechanicListener;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.US);

    @Override
    public boolean isEnabled() {
        return PacketAdapter.isProtocolLibEnabled();
    }

    @Override
    public void registerInventoryListener() {
        if (this.inventoryPacketListener != null) {
            OraxenPlugin.get().getLogger().severe("[ProtocolLibAdapter]: Inventory Listener is already registered!");
            return;
        }
        this.inventoryPacketListener = new InventoryPacketListener();
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.inventoryPacketListener);
    }

    @Override
    public void registerScoreboardListener() {
        if (this.scoreboardPacketListener != null) {
            OraxenPlugin.get().getLogger().severe("[ProtocolLibAdapter]: Scoreboard Listener is already registered!");
            return;
        }
        this.scoreboardPacketListener = new ScoreboardPacketListener();
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.scoreboardPacketListener);
    }

    @Override
    public void registerTitleListener() {
        if (this.titlePacketListener != null) {
            OraxenPlugin.get().getLogger().severe("[ProtocolLibAdapter]: Title Listener is already registered!");
            return;
        }
        this.titlePacketListener = new TitlePacketListener();
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.titlePacketListener);
    }

    @Override
    public void removeInventoryListener() {
        if (this.inventoryPacketListener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.inventoryPacketListener);
        }
        this.inventoryPacketListener = null;
    }

    @Override
    public void removeTitleListener() {
        if (this.titlePacketListener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.titlePacketListener);
        }
        this.titlePacketListener = null;
    }

    @Override
    public void reregisterEfficencyMechanicListener(EfficiencyMechanicFactory efficiencyMechanicFactory) {
        if (this.efficiencyMechanicListener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.efficiencyMechanicListener);
        }
        this.efficiencyMechanicListener = new EfficiencyMechanicListener(efficiencyMechanicFactory);
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.efficiencyMechanicListener);
    }

    @Override
    public String getLatestMCVersion() {
        return "1.21.8";
    }

    @Override
    public boolean isNewer(SnapshotVersion snapshot) {
        try {
            return snapshot.getSnapshotDate().after(DATE_FORMAT.parse("2025-07-17"));
        }
        catch (ParseException ignored) {
            return true;
        }
    }

    @Override
    @Nullable
    public Plugin getPlugin() {
        return Bukkit.getPluginManager().getPlugin("ProtocolLib");
    }
}

