/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.pack.generation.PackSlicer;
import io.th0rgal.oraxen.utils.VirtualFile;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AtlasGenerator {
    public static void generateAtlasFile(List<VirtualFile> output, Set<String> malformedTextures) {
        Logs.logSuccess("Generating atlas-file for 1.19.3+ Resource Pack format");
        if (Settings.EXCLUDE_MALFORMED_ATLAS.toBool().booleanValue() && !malformedTextures.isEmpty()) {
            Logs.logWarning("Attempting to exclude malformed textures from atlas-file");
        }
        JsonObject atlas = new JsonObject();
        JsonArray atlasContent = new JsonArray();
        LinkedHashMap<VirtualFile, TexturePath> textureSubFolders = new LinkedHashMap<VirtualFile, TexturePath>();
        for (VirtualFile v2 : output.stream().filter(v -> v.getPath().split("/").length > 3 && v.getPath().split("/")[2].equals("textures") && v.getPath().endsWith(".png") && !v.getPath().endsWith("_layer_1.png") && !v.getPath().endsWith("_layer_2.png") && PackSlicer.INPUTS.stream().noneMatch(input -> v.getPath().endsWith(input.path)) && PackSlicer.OUTPUT_PATHS.stream().noneMatch(outPath -> v.getPath().endsWith((String)outPath))).sorted().collect(Collectors.toCollection(LinkedHashSet::new))) {
            textureSubFolders.put(v2, new TexturePath(StringUtils.substringBetween((String)v2.getPath(), (String)"assets/", (String)"/textures"), StringUtils.substringAfter((String)v2.getPath(), (String)"textures/")));
        }
        HashSet<TexturePath> itemTextures = new HashSet<TexturePath>();
        OraxenItems.getItems().stream().filter(builder -> builder.hasOraxenMeta() && builder.getOraxenMeta().hasLayers()).forEach(builder -> itemTextures.addAll(builder.getOraxenMeta().getLayers().stream().map(TexturePath::new).toList()));
        LinkedHashSet<TexturePath> fontTextures = new LinkedHashSet<TexturePath>();
        Set fonts = output.stream().filter(v -> v.getPath().matches("assets/.*/font/.*.json") && v.isJsonObject()).map(VirtualFile::toJsonObject).collect(Collectors.toSet());
        for (JsonObject jsonObject : fonts) {
            if (jsonObject == null || !jsonObject.has("providers")) continue;
            for (JsonElement providerElement : jsonObject.getAsJsonArray("providers")) {
                JsonObject provider;
                if (!providerElement.isJsonObject() || !(provider = providerElement.getAsJsonObject()).has("file")) continue;
                fontTextures.add(new TexturePath(provider.get("file").getAsString()));
            }
        }
        for (Map.Entry entry : textureSubFolders.entrySet()) {
            TexturePath texturePath = (TexturePath)entry.getValue();
            if (texturePath.in(fontTextures) && !texturePath.in(itemTextures)) continue;
            JsonObject atlasEntry = new JsonObject();
            String malformPathCheck = "assets/" + texturePath.namespace + "/textures/" + texturePath.path + ".png";
            if (Settings.EXCLUDE_MALFORMED_ATLAS.toBool().booleanValue()) {
                if (malformedTextures.stream().anyMatch(malformPathCheck::startsWith)) {
                    Logs.logWarning("Excluding malformed texture from atlas-file: <gold>" + malformPathCheck);
                    continue;
                }
            }
            if (Settings.ATLAS_GENERATION_TYPE.toString().equals("DIRECTORY")) {
                String path = StringUtils.substringBeforeLast((String)texturePath.path, (String)"/");
                atlasEntry.addProperty("type", "directory");
                atlasEntry.addProperty("source", path);
                atlasEntry.addProperty("prefix", path + "/");
            } else {
                atlasEntry.addProperty("type", "single");
                atlasEntry.addProperty("resource", texturePath.toPath());
                atlasEntry.addProperty("sprite", texturePath.toPath());
            }
            if (atlasContent.contains((JsonElement)atlasEntry)) continue;
            atlasContent.add((JsonElement)atlasEntry);
        }
        AtlasGenerator.removeChildEntriesInDirectoryAtlas(atlasContent);
        atlas.add("sources", (JsonElement)atlasContent);
        VirtualFile atlasFile = new VirtualFile("assets/minecraft/atlases", "blocks.json", new ByteArrayInputStream(atlas.toString().getBytes(StandardCharsets.UTF_8)));
        output.removeIf(v -> v.getPath().equals(atlasFile.getPath()));
        output.add(atlasFile);
    }

    private static void removeChildEntriesInDirectoryAtlas(JsonArray atlasContent) {
        if (Settings.ATLAS_GENERATION_TYPE.toString().equals("DIRECTORY")) {
            HashSet remove = new HashSet();
            atlasContent.forEach(element -> {
                String source = element.getAsJsonObject().get("source").getAsString();
                if (source.contains("/")) {
                    JsonObject parentObject = new JsonObject();
                    parentObject.addProperty("type", "directory");
                    parentObject.addProperty("source", source);
                    parentObject.addProperty("prefix", source + "/");
                    if (atlasContent.contains((JsonElement)parentObject)) {
                        remove.add(element);
                    }
                }
            });
            remove.forEach(arg_0 -> ((JsonArray)atlasContent).remove(arg_0));
        }
    }

    private static class TexturePath {
        public final String namespace;
        public final String path;

        public TexturePath(String namespace, String path) {
            this.namespace = namespace;
            this.path = path.replace(".png", "");
        }

        public TexturePath(String path) {
            this.namespace = path.contains(":") ? StringUtils.substringBefore((String)path, (String)":") : "minecraft";
            this.path = (path.contains(":") ? path.split(":")[1] : path).replace(".png", "");
        }

        public String toPath() {
            return this.namespace + ":" + this.path;
        }

        public boolean in(Collection<TexturePath> texturePaths) {
            return texturePaths.stream().anyMatch(texturePath -> this.namespace.equals(texturePath.namespace) && this.path.equals(texturePath.path));
        }
    }
}

