/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.light;

import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Light;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class LightMechanic {
    private static final BlockFace[] BLOCK_FACES = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.SELF};
    private final Light lightData;
    private final int lightLevel;

    public LightMechanic(ConfigurationSection section) {
        this.lightLevel = Math.min(15, section.getInt("light", -1));
        Light light = this.lightData = this.lightLevel == -1 ? null : (Light)Material.LIGHT.createBlockData();
        if (this.lightData != null) {
            this.lightData.setLevel(this.lightLevel);
        }
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public boolean hasLightLevel() {
        return this.lightLevel != -1 && this.lightData != null;
    }

    public void createBlockLight(Block block) {
        if (!this.hasLightLevel()) {
            return;
        }
        if (block.getType().isAir()) {
            block.setBlockData((BlockData)this.lightData);
        } else {
            for (BlockFace face : BLOCK_FACES) {
                Light relativeLight;
                BlockData blockData;
                Block relative = block.getRelative(face);
                if (!relative.getType().isAir() && relative.getType() != Material.LIGHT || (blockData = relative.getBlockData()) instanceof Light && (relativeLight = (Light)blockData).getLevel() > this.lightLevel) continue;
                relative.setBlockData((BlockData)this.lightData);
            }
        }
    }

    public void removeBlockLight(Block block) {
        if (this.hasLightLevel()) {
            for (BlockFace face : BLOCK_FACES) {
                Block relative = block.getRelative(face);
                if (relative.getType() == Material.LIGHT) {
                    relative.setType(Material.AIR);
                }
                for (BlockFace relativeFace : BLOCK_FACES) {
                    if (relativeFace != face.getOppositeFace()) continue;
                }
            }
        }
    }

    public static void refreshBlockLight(Block block) {
        if (block.getType() == Material.LIGHT || block.getType().isAir()) {
            return;
        }
        for (BlockFace face : BLOCK_FACES) {
            FurnitureMechanic furnitureMechanic;
            StringBlockMechanic stringBlockMechanic;
            NoteBlockMechanic noteBlockMechanic = OraxenBlocks.getNoteBlockMechanic(block = block.getRelative(face));
            if (noteBlockMechanic != null) {
                if (!noteBlockMechanic.hasLight()) continue;
                noteBlockMechanic.getLight().createBlockLight(block);
            }
            if ((stringBlockMechanic = OraxenBlocks.getStringMechanic(block)) != null) {
                if (!stringBlockMechanic.hasLight()) continue;
                stringBlockMechanic.getLight().createBlockLight(block);
            }
            if ((furnitureMechanic = OraxenFurniture.getFurnitureMechanic(block)) == null) continue;
            Entity baseEntity = furnitureMechanic.getBaseEntity(block);
            if (!furnitureMechanic.hasLight() || baseEntity == null) continue;
            furnitureMechanic.setEntityData(baseEntity, FurnitureMechanic.getFurnitureYaw(baseEntity), baseEntity.getFacing());
        }
    }
}

