/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureMechanic;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class AdminCommand {
    CommandAPICommand getAdminCommand() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("admin").withPermission("oraxen.command.admin")).withSubcommands(new CommandAPICommand[]{this.getFurniturePlaceRemoveCommand(), this.getNoteblockPlaceRemoveCommand()});
    }

    private CommandAPICommand getNoteblockPlaceRemoveCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("block").withArguments(new Argument[]{(Argument)new TextArgument("block").replaceSuggestions(ArgumentSuggestions.strings(OraxenBlocks.getBlockIDs()))})).withArguments(new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings("place", "remove"))})).withOptionalArguments(new Argument[]{new LocationArgument("location")})).withOptionalArguments(new Argument[]{new IntegerArgument("radius")})).withOptionalArguments(new Argument[]{new BooleanArgument("random")})).executesPlayer((player, args) -> {
            String id = (String)args.get("block");
            if (!OraxenBlocks.isOraxenBlock(id)) {
                OraxenPlugin.get().getAudience().player(player).sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<red>Unknown OraxenBlock: <yellow>" + id)));
            } else {
                Location loc = (Location)args.getOptional("location").orElse(player.getLocation());
                String type = (String)args.get("type");
                int radius = (Integer)args.getOptional("radius").orElse(1);
                boolean isRandom = (Boolean)args.getOptional("random").orElse(false);
                for (Block block : this.getBlocks(loc, radius, isRandom)) {
                    if (type == null) continue;
                    if (type.equals("remove")) {
                        OraxenBlocks.remove(block.getLocation(), null);
                    }
                    if (!type.equals("place")) continue;
                    OraxenBlocks.place(id, block.getLocation());
                }
            }
        });
    }

    private CommandAPICommand getFurniturePlaceRemoveCommand() {
        Set<String> furnitureIDs = OraxenFurniture.getFurnitureIDs();
        furnitureIDs.add("all");
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("furniture").withArguments(new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings("place", "remove")), (Argument)new TextArgument("furniture").replaceSuggestions(ArgumentSuggestions.strings(furnitureIDs))})).withOptionalArguments(new Argument[]{new LocationArgument("location"), new IntegerArgument("radius"), new BooleanArgument("random")})).executesPlayer((player, args) -> {
            String type = (String)args.get("type");
            assert (type != null);
            String id = (String)args.getOrDefault("furniture", (Object)"");
            if (!OraxenFurniture.isFurniture(id)) {
                OraxenPlugin.get().getAudience().player(player).sendMessage(AdventureUtils.MINI_MESSAGE.deserialize((Object)("<red>Unknown Furniture: <yellow>" + id)));
            } else {
                Location loc = (Location)args.getOptional("location").orElse(player.getLocation());
                int radius = (Integer)args.getOptional("radius").orElse(0);
                boolean isRandom = (Boolean)args.getOptional("random").orElse(false);
                for (Block block : this.getBlocks(loc, radius, isRandom)) {
                    FurnitureMechanic mechanic;
                    if (type.equals("remove") && (mechanic = OraxenFurniture.getFurnitureMechanic(block)) != null && (id.isEmpty() || id.equals("all") || mechanic.getItemID().equals(id))) {
                        OraxenFurniture.remove(block.getLocation(), null);
                    }
                    if (!type.equals("place")) continue;
                    OraxenFurniture.place(id, block.getLocation(), 0.0f, null);
                }
            }
        });
    }

    private Collection<Block> getBlocks(Location loc, int radius, boolean isRandom) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (radius <= 0) {
            return Collections.singletonList(loc.getBlock());
        }
        for (int x = loc.getBlockX() - radius; x <= loc.getBlockX() + radius; ++x) {
            for (int z = loc.getBlockZ() - radius; z <= loc.getBlockZ() + radius; ++z) {
                for (int y = loc.getBlockY() - radius; y <= loc.getBlockY() + radius; ++y) {
                    blocks.add(loc.getWorld().getBlockAt(x, y, z));
                }
            }
        }
        if (isRandom) {
            return Collections.singletonList((Block)blocks.get(new Random().nextInt(blocks.size())));
        }
        return blocks;
    }
}

