/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.util.version;

import com.github.stefvanschie.inventoryframework.exception.UnsupportedVersionException;
import java.util.Collection;
import java.util.EnumSet;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum Version {
    V1_16_1,
    V1_16_2_3,
    V1_16_4_5,
    V1_17_0,
    V1_17_1,
    V1_18_0,
    V1_18_1,
    V1_18_2,
    V1_19_0,
    V1_19_1,
    V1_19_2,
    V1_19_3,
    V1_19_4,
    V1_20_0,
    V1_20_1,
    V1_20_2,
    V1_20_3_4,
    V1_20_5,
    V1_20_6,
    V1_21_0,
    V1_21_1,
    V1_21_2_3,
    V1_21_4,
    V1_21_5,
    V1_21_6_8;

    private static final Collection<Version> MODERN_SMITHING_TABLE_VERSIONS;
    @NotNull
    private static final @NotNull Collection<@NotNull Version> LEGACY_SMITHING_TABLE_VERSIONS;
    @NotNull
    private static final @NotNull Collection<@NotNull Version> INTERFACE_INVENTORY_VIEW;

    @Contract(pure=true)
    public boolean isInventoryViewInterface() {
        return INTERFACE_INVENTORY_VIEW.contains((Object)this);
    }

    boolean existsModernSmithingTable() {
        return MODERN_SMITHING_TABLE_VERSIONS.contains((Object)this);
    }

    @Contract(pure=true)
    boolean existsLegacySmithingTable() {
        return LEGACY_SMITHING_TABLE_VERSIONS.contains((Object)this);
    }

    @NotNull
    @Contract(pure=true)
    public static Version getVersion() {
        String version;
        switch (version = Bukkit.getBukkitVersion().split("-")[0]) {
            case "1.16.1": {
                return V1_16_1;
            }
            case "1.16.2": 
            case "1.16.3": {
                return V1_16_2_3;
            }
            case "1.16.4": 
            case "1.16.5": {
                return V1_16_4_5;
            }
            case "1.17": {
                return V1_17_0;
            }
            case "1.17.1": {
                return V1_17_1;
            }
            case "1.18": {
                return V1_18_0;
            }
            case "1.18.1": {
                return V1_18_1;
            }
            case "1.18.2": {
                return V1_18_2;
            }
            case "1.19": {
                return V1_19_0;
            }
            case "1.19.1": {
                return V1_19_1;
            }
            case "1.19.2": {
                return V1_19_2;
            }
            case "1.19.3": {
                return V1_19_3;
            }
            case "1.19.4": {
                return V1_19_4;
            }
            case "1.20": {
                return V1_20_0;
            }
            case "1.20.1": {
                return V1_20_1;
            }
            case "1.20.2": {
                return V1_20_2;
            }
            case "1.20.3": 
            case "1.20.4": {
                return V1_20_3_4;
            }
            case "1.20.5": {
                return V1_20_5;
            }
            case "1.20.6": {
                return V1_20_6;
            }
            case "1.21": {
                return V1_21_0;
            }
            case "1.21.1": {
                return V1_21_1;
            }
            case "1.21.2": 
            case "1.21.3": {
                return V1_21_2_3;
            }
            case "1.21.4": {
                return V1_21_4;
            }
            case "1.21.5": {
                return V1_21_5;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                return V1_21_6_8;
            }
        }
        throw new UnsupportedVersionException("The server version provided is not supported");
    }

    static {
        MODERN_SMITHING_TABLE_VERSIONS = EnumSet.of(V1_19_4, new Version[]{V1_20_0, V1_20_1, V1_20_2, V1_20_3_4, V1_20_5, V1_20_6, V1_21_0, V1_21_1, V1_21_2_3, V1_21_4, V1_21_5, V1_21_6_8});
        LEGACY_SMITHING_TABLE_VERSIONS = EnumSet.of(V1_16_1, new Version[]{V1_16_2_3, V1_16_4_5, V1_17_0, V1_17_1, V1_18_0, V1_18_1, V1_18_2, V1_19_0, V1_19_1, V1_19_2, V1_19_3, V1_19_4});
        INTERFACE_INVENTORY_VIEW = EnumSet.of(V1_21_0, new Version[]{V1_21_1, V1_21_2_3, V1_21_4, V1_21_5, V1_21_6_8});
    }
}

