/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_1;

import com.github.stefvanschie.inventoryframework.abstraction.StonecutterInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_1.util.TextHolderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.Container;
import net.minecraft.server.v1_16_R1.ContainerAccess;
import net.minecraft.server.v1_16_R1.ContainerStonecutter;
import net.minecraft.server.v1_16_R1.EntityHuman;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.IInventory;
import net.minecraft.server.v1_16_R1.InventoryLargeChest;
import net.minecraft.server.v1_16_R1.InventorySubcontainer;
import net.minecraft.server.v1_16_R1.ItemStack;
import net.minecraft.server.v1_16_R1.NonNullList;
import net.minecraft.server.v1_16_R1.PlayerInventory;
import net.minecraft.server.v1_16_R1.Slot;
import net.minecraft.server.v1_16_R1.TileEntityContainer;
import net.minecraft.server.v1_16_R1.TileEntityTypes;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StonecutterInventoryImpl
extends StonecutterInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(final @NotNull TextHolder title) {
        final InventorySubcontainer resultSlot = new InventorySubcontainer(1);
        InventoryViewProvider container = new InventoryViewProvider(){

            @NotNull
            @Contract(pure=true)
            public Container createContainer(int containerId, @NotNull PlayerInventory inventory) {
                return new ContainerStonecutterImpl(containerId, inventory.player, (IInventory)this, (IInventory)resultSlot);
            }

            @NotNull
            @Contract(pure=true)
            public IChatBaseComponent getContainerName() {
                return TextHolderUtil.toComponent(title);
            }
        };
        return new CraftInventoryStonecutter((IInventory)container, (IInventory)resultSlot, (IInventory)container){
            final /* synthetic */ IInventory val$container;
            {
                this.val$container = iInventory;
                super(inventory, resultInventory);
            }

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.STONECUTTER;
            }

            public IInventory getInventory() {
                return this.val$container;
            }
        };
    }

    private static class ContainerStonecutterImpl
    extends ContainerStonecutter {
        @NotNull
        private final HumanEntity humanEntity;
        @NotNull
        private final IInventory inputSlot;
        @NotNull
        private final IInventory resultSlot;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerStonecutterImpl(int containerId, @NotNull EntityHuman player, @NotNull IInventory inputSlot, @NotNull IInventory resultSlot) {
            super(containerId, player.inventory, ContainerAccess.at((World)player.getWorld(), (BlockPosition)BlockPosition.ZERO));
            this.humanEntity = player.getBukkitEntity();
            this.inputSlot = inputSlot;
            this.resultSlot = resultSlot;
            this.checkReachable = false;
            InventoryLargeChest container = new InventoryLargeChest(inputSlot, resultSlot);
            this.updateSlot(0, (IInventory)container);
            this.updateSlot(1, (IInventory)container);
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventoryStonecutter inventory = new CraftInventoryStonecutter(this.inputSlot, this.resultSlot);
            this.bukkitEntity = new CraftInventoryView(this.humanEntity, (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }

        @Contract(value="_, _ -> false", pure=true)
        public boolean a(@Nullable EntityHuman player, int index) {
            return false;
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.slots.get(slotIndex);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(slotIndex, newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends TileEntityContainer {
        private final int size = 1;
        public ItemStack item = ItemStack.b;
        public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 1;

        protected InventoryViewProvider() {
            super(TileEntityTypes.BEACON);
        }

        public void clear() {
            this.item = ItemStack.b;
            this.update();
        }

        public int getSize() {
            return 1;
        }

        public boolean isEmpty() {
            return this.item.isEmpty();
        }

        public ItemStack getItem(int index) {
            return index == 0 ? this.item : ItemStack.b;
        }

        public ItemStack splitStack(int firstIndex, int secondIndex) {
            ItemStack itemstack;
            ItemStack itemStack = itemstack = firstIndex == 0 && !this.item.isEmpty() && secondIndex > 0 ? this.item.cloneAndSubtract(secondIndex) : ItemStack.b;
            if (!itemstack.isEmpty()) {
                this.update();
            }
            return itemstack;
        }

        public ItemStack splitWithoutUpdate(int index) {
            ItemStack itemstack = this.getItem(index);
            if (itemstack.isEmpty()) {
                return ItemStack.b;
            }
            this.item = ItemStack.b;
            return itemstack;
        }

        public void setItem(int index, ItemStack itemStack) {
            this.item = itemStack;
            if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
                itemStack.setCount(this.getMaxStackSize());
            }
            this.update();
        }

        public int getMaxStackSize() {
            return this.maxStack;
        }

        public boolean a(EntityHuman entityHuman) {
            return true;
        }

        public List<ItemStack> getContents() {
            return NonNullList.a((Object)this.item, (Object[])new ItemStack[0]);
        }

        public void onOpen(CraftHumanEntity craftHumanEntity) {
            this.transaction.add((HumanEntity)craftHumanEntity);
        }

        public void onClose(CraftHumanEntity craftHumanEntity) {
            this.transaction.remove(craftHumanEntity);
        }

        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        public void setMaxStackSize(int maxStack) {
            this.maxStack = maxStack;
        }
    }
}

