/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.inventories;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.font.FontManager;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.recipes.CustomRecipe;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipesView {
    private final FontManager fontManager = OraxenPlugin.get().getFontManager();
    final String menuTexture = String.valueOf(ChatColor.WHITE) + this.fontManager.getShift(-7) + this.fontManager.getGlyphFromName("menu_recipe").getCharacter();

    public ChestGui create(int page, List<CustomRecipe> filteredRecipes) {
        ChestGui gui = new ChestGui(6, this.menuTexture);
        CustomRecipe currentRecipe = filteredRecipes.get(page);
        boolean lastPage = filteredRecipes.size() - 1 == page;
        StaticPane pane = new StaticPane(9, 6);
        pane.addItem(new GuiItem(currentRecipe.getResult()), 4, 0);
        for (int i = 0; i < currentRecipe.getIngredients().size(); ++i) {
            ItemStack itemStack = currentRecipe.getIngredients().get(i);
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            pane.addItem(new GuiItem(itemStack), 3 + i % 3, 2 + i / 3);
        }
        pane.addItem(new GuiItem((OraxenItems.getItemById("exit_icon") == null ? new ItemBuilder(Material.BARRIER) : OraxenItems.getItemById("exit_icon")).setDisplayName(Message.EXIT_MENU.toSerializedString()).build(), event -> event.getWhoClicked().closeInventory()), 4, 5);
        if (page > 0) {
            pane.addItem(new GuiItem((OraxenItems.getItemById("arrow_previous_icon") == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById("arrow_previous_icon")).setAmount(page).setDisplayName(String.valueOf(ChatColor.YELLOW) + "Open page " + page).build(), event -> this.create(page - 1, filteredRecipes).show(event.getWhoClicked())), 1, 3);
        }
        if (!lastPage) {
            pane.addItem(new GuiItem((OraxenItems.getItemById("arrow_next_icon") == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById("arrow_next_icon")).setAmount(page + 2).setDisplayName(String.valueOf(ChatColor.YELLOW) + "Open page " + (page + 2)).build(), event -> this.create(page + 1, filteredRecipes).show(event.getWhoClicked())), 7, 3);
        }
        gui.addPane((Pane)pane);
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        return gui;
    }
}

