/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSound {
    private final String name;
    private final SoundCategory category;
    private final String subtitle;
    private final boolean replace;
    private final List<String> sounds = new ArrayList<String>();
    private final boolean stream;
    private final Optional<JukeboxData> jukeboxData;

    public CustomSound(@NotNull String name, @NotNull ConfigurationSection config) {
        this.name = name;
        List<String> soundsList = config.getStringList("sounds");
        if (soundsList.isEmpty() && config.contains("sound")) {
            soundsList = Collections.singletonList(config.getString("sound"));
        }
        for (String sound : soundsList) {
            if (sound == null) continue;
            this.sounds.add(sound.replace(".ogg", ""));
        }
        String categoryStr = config.getString("category");
        this.category = categoryStr != null ? (categoryStr.toUpperCase(Locale.ROOT).equals("RECORD") ? SoundCategory.RECORDS : SoundCategory.valueOf((String)categoryStr.toUpperCase(Locale.ROOT))) : SoundCategory.MASTER;
        this.subtitle = config.getString("subtitle");
        this.replace = config.getBoolean("replace", false);
        this.stream = config.getBoolean("stream", false);
        ConfigurationSection jukeboxSection = config.getConfigurationSection("jukebox_song");
        if (jukeboxSection != null) {
            String descriptionText = jukeboxSection.getString("description", this.subtitle != null ? this.subtitle : "<white>Music Disc</white>");
            this.jukeboxData = Optional.of(new JukeboxData(AdventureUtils.MINI_MESSAGE.deserialize((Object)descriptionText), jukeboxSection.getInt("length_in_seconds", 120), jukeboxSection.getInt("comparator_output", 15)));
        } else {
            this.jukeboxData = Optional.empty();
        }
    }

    public void play(@NotNull Player player, @NotNull Location location) {
        this.play(player, location, 1.0f, 1.0f);
    }

    public void play(@NotNull Player player, @NotNull Location location, float volume, float pitch) {
        this.play(player, location, this.category, volume, pitch);
    }

    public void play(@NotNull Player player, @NotNull Location location, @NotNull SoundCategory category, float volume, float pitch) {
        player.playSound(location, this.name, category, volume, pitch);
    }

    public void stop(@NotNull Player player) {
        this.stop(player, null);
    }

    public void stop(@NotNull Player player, @Nullable SoundCategory category) {
        player.stopSound(this.name, category);
    }

    public String getName() {
        return this.name;
    }

    public SoundCategory getCategory() {
        return this.category;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public List<String> getSounds() {
        return new ArrayList<String>(this.sounds);
    }

    public boolean isStream() {
        return this.stream;
    }

    public boolean isJukeboxSound() {
        return this.jukeboxData.isPresent();
    }

    public int getLengthInSeconds() {
        return this.jukeboxData.map(data -> data.lengthInSeconds).orElse(120);
    }

    public int getComparatorOutput() {
        return this.jukeboxData.map(data -> data.comparatorOutput).orElse(15);
    }

    public Component getDescription() {
        return this.jukeboxData.map(data -> data.description).orElse(AdventureUtils.MINI_MESSAGE.deserialize((Object)"<white>Music Disc</white>"));
    }

    public JsonObject toJson() {
        JsonObject output = new JsonObject();
        if (this.category != null) {
            output.addProperty("category", this.category.toString().toLowerCase(Locale.ROOT));
        }
        if (this.replace) {
            output.addProperty("replace", Boolean.valueOf(true));
        }
        if (this.subtitle != null) {
            output.addProperty("subtitle", this.subtitle);
        }
        if (this.stream) {
            output.addProperty("stream", Boolean.valueOf(true));
        }
        JsonArray sounds = new JsonArray();
        if (this.sounds.isEmpty()) {
            sounds.getAsJsonArray();
        } else {
            for (String sound : this.sounds) {
                sounds.add(sound);
            }
        }
        output.add("sounds", (JsonElement)sounds);
        return output;
    }

    public String getSoundId() {
        return "minecraft:" + this.name;
    }

    public JsonObject toJukeboxJson() {
        if (this.jukeboxData.isEmpty()) {
            return new JsonObject();
        }
        JsonObject songJson = new JsonObject();
        JsonObject soundEvent = new JsonObject();
        soundEvent.addProperty("sound_id", this.getSoundId());
        songJson.add("sound_event", (JsonElement)soundEvent);
        songJson.add("description", AdventureUtils.GSON_SERIALIZER.serializeToTree(this.getDescription()));
        songJson.addProperty("length_in_seconds", (Number)this.getLengthInSeconds());
        songJson.addProperty("comparator_output", (Number)this.getComparatorOutput());
        return songJson;
    }

    private record JukeboxData(Component description, int lengthInSeconds, int comparatorOutput) {
    }
}

