/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.breaker;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.DiggingAction;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockBreakAnimation;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class PacketEventsBreakerSystem
extends BreakerSystem {
    private final PacketListener listener = new PacketListener(){

        public void onPacketReceive(PacketReceiveEvent event) {
            BlockFace blockFace;
            if (!event.getPacketType().equals((Object)PacketType.Play.Client.PLAYER_DIGGING)) {
                return;
            }
            WrapperPlayClientPlayerDigging wrapper = new WrapperPlayClientPlayerDigging(event);
            Player player = (Player)event.getPlayer();
            Vector3i pos = wrapper.getBlockPosition();
            try {
                blockFace = BlockFace.valueOf((String)wrapper.getBlockFace().name());
            }
            catch (IllegalArgumentException e) {
                OraxenPlugin.get().getLogger().warning("[PacketEvents] Failed to decode BlockFace: " + wrapper.getBlockFace().name());
                blockFace = BlockFace.UP;
            }
            World world = player.getWorld();
            Block block = world.getBlockAt(pos.getX(), pos.getY(), pos.getZ());
            Location location = block.getLocation();
            PacketEventsBreakerSystem.this.handleEvent(player, block, location, blockFace, world, () -> event.setCancelled(true), wrapper.getAction() == DiggingAction.START_DIGGING);
        }
    };

    @Override
    protected void sendBlockBreak(Player player, Location location, int stage) {
        WrapperPlayServerBlockBreakAnimation wrapper = new WrapperPlayServerBlockBreakAnimation(player.getEntityId(), new Vector3i(location.getBlockX(), location.getBlockY(), location.getBlockZ()), (byte)stage);
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)wrapper);
    }

    @Override
    public void registerListener() {
        PacketEvents.getAPI().getEventManager().registerListener(this.listener, PacketListenerPriority.LOWEST);
    }
}

