/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class OraxenYaml
extends YamlConfiguration {
    public static boolean isValidYaml(File file) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
            return true;
        }
        catch (InvalidConfigurationException e) {
            Logs.logError("Error loading YAML configuration file: " + file.getPath());
            Logs.logError("Ensure that your config is formatted correctly:");
            Logs.logWarning(e.getMessage());
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull File file) throws RuntimeException {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (InvalidConfigurationException e) {
            Logs.logError("Error loading YAML configuration file: " + file.getName());
            Logs.logError("Ensure that your config is formatted correctly:");
            Logs.logWarning(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public void load(@NotNull File file) {
        block2: {
            try {
                super.load(file);
            }
            catch (Exception e) {
                Logs.logError("Error loading YAML configuration file: " + file.getName());
                if (!Settings.DEBUG.toBool().booleanValue()) break block2;
                Logs.logWarning(e.getMessage());
            }
        }
    }

    public static void saveConfig(@NotNull File file, @NotNull ConfigurationSection section) {
        block2: {
            try {
                YamlConfiguration config = OraxenYaml.loadConfiguration(file);
                config.set(section.getCurrentPath(), (Object)section);
                config.save(file);
            }
            catch (Exception e) {
                Logs.logError("Error saving YAML configuration file: " + file.getName());
                if (!Settings.DEBUG.toBool().booleanValue()) break block2;
                Logs.logWarning(e.getMessage());
            }
        }
    }

    public static void copyConfigurationSection(ConfigurationSection source, ConfigurationSection target) {
        for (String key : source.getKeys(false)) {
            Object sourceValue = source.get(key);
            Object targetValue = target.get(key);
            if (sourceValue instanceof ConfigurationSection) {
                ConfigurationSection existingSection;
                ConfigurationSection sourceSection = (ConfigurationSection)sourceValue;
                ConfigurationSection targetSection = targetValue instanceof ConfigurationSection ? (existingSection = (ConfigurationSection)targetValue) : target.createSection(key);
                OraxenYaml.copyConfigurationSection(sourceSection, targetSection);
                continue;
            }
            target.set(key, sourceValue);
        }
    }
}

