/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.packets;

import io.th0rgal.oraxen.mechanics.provided.gameplay.efficiency.EfficiencyMechanicFactory;
import io.th0rgal.oraxen.utils.PluginUtils;
import io.th0rgal.oraxen.utils.SnapshotVersion;
import java.util.function.Consumer;

public interface PacketAdapter {
    public static boolean isPacketEventsEnabled() {
        return PluginUtils.isEnabled("PacketEvents");
    }

    public static boolean isProtocolLibEnabled() {
        return PluginUtils.isEnabled("ProtocolLib");
    }

    public boolean isEnabled();

    default public boolean whenEnabled(Consumer<PacketAdapter> whenEnabled) {
        boolean enabled = this.isEnabled();
        if (enabled && whenEnabled != null) {
            whenEnabled.accept(this);
        }
        return enabled;
    }

    public void registerInventoryListener();

    public void registerScoreboardListener();

    public void registerTitleListener();

    public void removeInventoryListener();

    public void removeTitleListener();

    public void reregisterEfficencyMechanicListener(EfficiencyMechanicFactory var1);

    public String getLatestMCVersion();

    public boolean isNewer(SnapshotVersion var1);

    public static class EmptyAdapter
    implements PacketAdapter {
        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void registerInventoryListener() {
        }

        @Override
        public void registerScoreboardListener() {
        }

        @Override
        public void registerTitleListener() {
        }

        @Override
        public void removeInventoryListener() {
        }

        @Override
        public void removeTitleListener() {
        }

        @Override
        public void reregisterEfficencyMechanicListener(EfficiencyMechanicFactory efficiencyMechanicFactory) {
        }

        @Override
        public String getLatestMCVersion() {
            return "1.21.8";
        }

        @Override
        public boolean isNewer(SnapshotVersion snapshot) {
            return true;
        }
    }
}

