/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import io.th0rgal.oraxen.config.Settings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;

public class ModelData {
    public static final int STARTING_CMD = 1000;
    private final Material type;
    private final int modelData;
    public static final Map<Material, Map<String, Integer>> DATAS = new HashMap<Material, Map<String, Integer>>();

    public ModelData(Material type, String model, int modelData) {
        this.type = type;
        this.modelData = modelData;
        Map usedModelDatas = DATAS.getOrDefault(type, new HashMap());
        usedModelDatas.put(model, modelData);
        DATAS.put(type, usedModelDatas);
    }

    public Material getType() {
        return this.type;
    }

    public int getModelData() {
        return this.modelData;
    }

    public static int generateId(String model, Material type) {
        Map<String, Integer> usedModelDatas = new HashMap<String, Integer>();
        if (!DATAS.containsKey(type) && !ModelData.getSkippedCustomModelData().contains(1000)) {
            usedModelDatas.put(model, 1000);
            DATAS.put(type, usedModelDatas);
            return 1000;
        }
        usedModelDatas = DATAS.getOrDefault(type, new HashMap());
        if (usedModelDatas.containsKey(model)) {
            return (Integer)usedModelDatas.get(model);
        }
        if (usedModelDatas.isEmpty()) {
            int newModelData = 1000;
            while (ModelData.getSkippedCustomModelData().contains(newModelData)) {
                ++newModelData;
            }
            usedModelDatas.put(model, newModelData);
            DATAS.put(type, usedModelDatas);
            return newModelData;
        }
        int currentHighestModelData = (Integer)Collections.max(usedModelDatas.values());
        for (int i = 1000; i < currentHighestModelData; ++i) {
            if (usedModelDatas.containsValue(i) || ModelData.getSkippedCustomModelData().contains(i)) continue;
            usedModelDatas.put(model, i);
            DATAS.put(type, usedModelDatas);
            return i;
        }
        int newHighestModelData = currentHighestModelData + 1;
        if (ModelData.getSkippedCustomModelData().contains(newHighestModelData)) {
            newHighestModelData = ModelData.getNextNotSkippedCustomModelData(newHighestModelData);
        }
        usedModelDatas.put(model, newHighestModelData);
        DATAS.put(type, usedModelDatas);
        return newHighestModelData;
    }

    private static int getNextNotSkippedCustomModelData(int i) {
        ArrayList<Integer> sorted = new ArrayList<Integer>(ModelData.getSkippedCustomModelData());
        sorted.sort(Comparator.naturalOrder());
        return sorted.stream().filter(index -> index > i).toList().get(0);
    }

    private static Set<Integer> getSkippedCustomModelData() {
        HashSet<Integer> skippedCustomModelData = new HashSet<Integer>();
        for (String s : Settings.SKIPPED_MODEL_DATA_NUMBERS.toStringList()) {
            if (s.contains("-")) {
                String[] s2 = s.split("-");
                int min = Integer.parseInt(s2[0]);
                int max = Integer.parseInt(s2[1]);
                for (int i = min; i <= max; ++i) {
                    skippedCustomModelData.add(i);
                }
                continue;
            }
            skippedCustomModelData.add(Integer.parseInt(s));
        }
        return skippedCustomModelData;
    }
}

