/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.ecoitems.WrappedEcoItem;
import io.th0rgal.oraxen.compatibilities.provided.mmoitems.WrappedMMOItem;
import io.th0rgal.oraxen.compatibilities.provided.mythiccrucible.WrappedCrucibleItem;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemTemplate;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.items.ModelData;
import io.th0rgal.oraxen.items.OraxenMeta;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.nms.NMSHandler;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.PotionUtils;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import io.th0rgal.oraxen.utils.wrappers.AttributeWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.Indyuce.mmoitems.MMOItems;
import net.kyori.adventure.key.Key;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ItemParser {
    public static final Map<String, ModelData> MODEL_DATAS_BY_ID = new HashMap<String, ModelData>();
    private final OraxenMeta oraxenMeta;
    private final ConfigurationSection section;
    private final Material type;
    private WrappedMMOItem mmoItem;
    private WrappedCrucibleItem crucibleItem;
    private WrappedEcoItem ecoItem;
    private ItemParser templateItem;
    private boolean configUpdated = false;

    public ItemParser(ConfigurationSection section) {
        this.section = section;
        if (section.isString("template")) {
            this.templateItem = ItemTemplate.getParserTemplate(section.getString("template"));
        }
        ConfigurationSection crucibleSection = section.getConfigurationSection("crucible");
        ConfigurationSection mmoSection = section.getConfigurationSection("mmoitem");
        ConfigurationSection ecoItemSection = section.getConfigurationSection("ecoitem");
        if (crucibleSection != null) {
            this.crucibleItem = new WrappedCrucibleItem(crucibleSection);
        } else if (section.isString("crucible_id")) {
            this.crucibleItem = new WrappedCrucibleItem(section.getString("crucible_id"));
        } else if (ecoItemSection != null) {
            this.ecoItem = new WrappedEcoItem(ecoItemSection);
        } else if (section.isString("ecoitem_id")) {
            this.ecoItem = new WrappedEcoItem(section.getString("ecoitem_id"));
        } else if (mmoSection != null) {
            this.mmoItem = new WrappedMMOItem(mmoSection);
        }
        Material material = Material.getMaterial((String)section.getString("material", ""));
        if (material == null) {
            material = this.usesTemplate() ? this.templateItem.type : Material.PAPER;
        }
        this.type = material;
        OraxenMeta oraxenMeta = this.oraxenMeta = this.templateItem != null ? this.templateItem.oraxenMeta : new OraxenMeta();
        if (section.isConfigurationSection("Pack")) {
            ConfigurationSection packSection = section.getConfigurationSection("Pack");
            this.oraxenMeta.setPackInfos(packSection);
            assert (packSection != null);
            if (packSection.isInt("custom_model_data")) {
                MODEL_DATAS_BY_ID.put(section.getName(), new ModelData(this.type, this.oraxenMeta.getModelName(), packSection.getInt("custom_model_data")));
            }
        }
    }

    public boolean usesMMOItems() {
        return this.crucibleItem == null && this.ecoItem == null && this.mmoItem != null && this.mmoItem.build() != null;
    }

    public boolean usesCrucibleItems() {
        return this.mmoItem == null && this.ecoItem == null && this.crucibleItem != null && this.crucibleItem.build() != null;
    }

    public boolean usesEcoItems() {
        return this.mmoItem == null && this.crucibleItem == null && this.ecoItem != null && this.ecoItem.build() != null;
    }

    public boolean usesTemplate() {
        return this.templateItem != null;
    }

    public ItemBuilder buildItem() {
        ItemBuilder item = this.usesCrucibleItems() ? new ItemBuilder(this.crucibleItem) : (this.usesMMOItems() ? new ItemBuilder(this.mmoItem) : (this.usesEcoItems() ? new ItemBuilder(this.ecoItem) : new ItemBuilder(this.type)));
        return this.applyConfig(this.usesTemplate() ? this.templateItem.applyConfig(item) : item);
    }

    private ItemBuilder applyConfig(ItemBuilder item) {
        try {
            if (this.section.contains("displayname")) {
                if (VersionUtil.atOrAbove("1.20.5")) {
                    this.configUpdated = true;
                } else {
                    item.setDisplayName(this.section.getString("displayname", ""));
                }
            }
            if (this.section.contains("customname")) {
                if (!VersionUtil.atOrAbove("1.20.5")) {
                    this.configUpdated = true;
                } else {
                    item.setDisplayName(this.section.getString("customname", ""));
                }
            }
            if (this.section.contains("lore")) {
                item.setLore(this.section.getStringList("lore").stream().map(AdventureUtils::parseMiniMessage).toList());
            }
            if (this.section.contains("unbreakable")) {
                item.setUnbreakable(this.section.getBoolean("unbreakable", false));
            }
            if (this.section.contains("unstackable")) {
                item.setUnstackable(this.section.getBoolean("unstackable", false));
            }
            if (this.section.contains("color")) {
                item.setColor(Utils.toColor(this.section.getString("color", "#FFFFFF")));
            }
            if (this.section.contains("trim_pattern")) {
                item.setTrimPattern(Key.key((String)this.section.getString("trim_pattern", "")));
            }
            this.parseDataComponents(item);
            this.parseMiscOptions(item);
            this.parseVanillaSections(item);
            this.parseOraxenSections(item);
            item.setOraxenMeta(this.oraxenMeta);
            return item;
        }
        catch (Exception e) {
            String itemId = this.section != null ? this.section.getName() : "unknown";
            Logs.logError("Error building item \"" + itemId + "\"");
            Logs.logError(e.getMessage());
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return item;
        }
    }

    private void parseDataComponents(ItemBuilder item) {
        ConfigurationSection section = this.mergeWithTemplateSection();
        if (section.contains("itemname") && VersionUtil.atOrAbove("1.20.5")) {
            item.setItemName(section.getString("itemname"));
        } else if (section.contains("displayname")) {
            item.setItemName(section.getString("displayname"));
        }
        ConfigurationSection components = section.getConfigurationSection("Components");
        if (components == null || !VersionUtil.atOrAbove("1.20.5")) {
            return;
        }
        this.handleLegacyComponents(item, components);
        if (VersionUtil.atOrAbove("1.21.3")) {
            for (String key : components.getKeys(false)) {
                Object value;
                if (this.isLegacyComponent(key) || !((value = components.get(key)) instanceof ConfigurationSection) && !(value instanceof Map)) continue;
                NMSHandlers.getHandler().setComponent(item, key, value);
            }
        }
    }

    private void handleLegacyComponents(ItemBuilder item, ConfigurationSection components) {
        NMSHandler nmsHandler;
        block20: {
            if (components.contains("durability")) {
                item.setDamagedOnBlockBreak(components.getBoolean("durability.damage_block_break"));
                item.setDamagedOnEntityHit(components.getBoolean("durability.damage_entity_hit"));
                item.setDurability(Math.max(components.getInt("durability.value"), components.getInt("durability", 1)));
            }
            if (components.contains("fire_resistant")) {
                item.setFireResistant(components.getBoolean("fire_resistant"));
            }
            if (components.contains("hide_tooltip")) {
                item.setHideToolTip(components.getBoolean("hide_tooltip"));
            }
            if ((nmsHandler = NMSHandlers.getHandler()) == null) {
                Logs.logWarning("NMSHandler is null - some components won't work properly");
                if (Settings.DEBUG.toBool().booleanValue()) {
                    Logs.logError("Item parsing: " + (this.section != null ? this.section.getName() : "unknown section"));
                    new Exception("NMSHandler is null").printStackTrace();
                }
            } else {
                Optional.ofNullable(components.getConfigurationSection("food")).ifPresent(food -> nmsHandler.foodComponent(item, (ConfigurationSection)food));
            }
            Optional.ofNullable(components.getConfigurationSection("tool")).ifPresent(toolSection -> this.parseToolComponent(item, (ConfigurationSection)toolSection));
            if (!VersionUtil.atOrAbove("1.21")) {
                return;
            }
            ConfigurationSection jukeboxSection = components.getConfigurationSection("jukebox_playable");
            if (jukeboxSection != null && VersionUtil.isPaperServer()) {
                try {
                    JukeboxPlayableComponent jukeboxPlayable;
                    block19: {
                        block18: {
                            jukeboxPlayable = new ItemStack(Material.MUSIC_DISC_CREATOR).getItemMeta().getJukeboxPlayable();
                            try {
                                jukeboxPlayable.setShowInTooltip(jukeboxSection.getBoolean("show_in_tooltip"));
                            }
                            catch (NoSuchMethodError e) {
                                Logs.logWarning("Error setting jukebox show_in_tooltip: This method is not available in your server version");
                                if (!Settings.DEBUG.toBool().booleanValue()) break block18;
                                e.printStackTrace();
                            }
                        }
                        try {
                            jukeboxPlayable.setSongKey(NamespacedKey.fromString((String)jukeboxSection.getString("song_key", "")));
                        }
                        catch (NoSuchMethodError e) {
                            Logs.logWarning("Error setting jukebox song_key: This method is not available in your server version");
                            if (!Settings.DEBUG.toBool().booleanValue()) break block19;
                            e.printStackTrace();
                        }
                    }
                    item.setJukeboxPlayable(jukeboxPlayable);
                }
                catch (Exception e) {
                    Logs.logWarning("Failed to create JukeboxPlayableComponent for item: " + this.section.getName());
                    if (Settings.DEBUG.toBool().booleanValue()) {
                        e.printStackTrace();
                    }
                    break block20;
                }
            }
            if (jukeboxSection != null) {
                Logs.logInfo("JukeboxPlayableComponent is only supported on Paper servers. Skipping this component.");
            }
        }
        if (!VersionUtil.atOrAbove("1.21.2")) {
            return;
        }
        Optional.ofNullable(components.getConfigurationSection("equippable")).ifPresent(equippable -> this.parseEquippableComponent(item, (ConfigurationSection)equippable));
        Optional.ofNullable(components.getConfigurationSection("use_cooldown")).ifPresent(cooldownSection -> {
            block3: {
                try {
                    UseCooldownComponent useCooldownComponent = new ItemStack(Material.PAPER).getItemMeta().getUseCooldown();
                    String group = Optional.ofNullable(cooldownSection.getString("group")).orElse("oraxen:" + OraxenItems.getIdByItem(item));
                    if (!group.isEmpty()) {
                        useCooldownComponent.setCooldownGroup(NamespacedKey.fromString((String)group));
                    }
                    useCooldownComponent.setCooldownSeconds((float)Math.max(cooldownSection.getDouble("seconds", 1.0), 0.0));
                    item.setUseCooldownComponent(useCooldownComponent);
                }
                catch (Exception | NoSuchMethodError e) {
                    Logs.logWarning("Error setting UseCooldownComponent: This component is not available in your server version");
                    if (!Settings.DEBUG.toBool().booleanValue()) break block3;
                    e.printStackTrace();
                }
            }
        });
        Optional.ofNullable(components.getConfigurationSection("use_remainder")).ifPresent(useRemainder -> this.parseUseRemainderComponent(item, (ConfigurationSection)useRemainder));
        Optional.ofNullable(components.getString("tooltip_style")).map(NamespacedKey::fromString).ifPresent(item::setTooltipStyle);
        Optional.ofNullable(components.getString("item_model")).map(NamespacedKey::fromString).ifPresent(item::setItemModel);
        if (nmsHandler != null) {
            Optional.ofNullable(components.getConfigurationSection("consumable")).ifPresent(consumableSection -> nmsHandler.consumableComponent(item, (ConfigurationSection)consumableSection));
        }
    }

    private boolean isLegacyComponent(String key) {
        return key.equals("durability") || key.equals("fire_resistant") || key.equals("hide_tooltip") || key.equals("food") || key.equals("tool") || key.equals("jukebox_playable") || key.equals("equippable") || key.equals("use_cooldown") || key.equals("use_remainder") || key.equals("tooltip_style") || key.equals("item_model") || key.equals("consumable");
    }

    private void parseUseRemainderComponent(ItemBuilder item, @NotNull ConfigurationSection useRemainderSection) {
        ItemStack result;
        int amount = useRemainderSection.getInt("amount", 1);
        if (useRemainderSection.contains("oraxen_item")) {
            result = ItemUpdater.updateItem(OraxenItems.getItemById(useRemainderSection.getString("oraxen_item")).build());
        } else if (useRemainderSection.contains("crucible_item")) {
            result = new WrappedCrucibleItem(useRemainderSection.getString("crucible_item")).build();
        } else if (useRemainderSection.contains("mmoitems_id") && useRemainderSection.isString("mmoitems_type")) {
            result = MMOItems.plugin.getItem(useRemainderSection.getString("mmoitems_type"), useRemainderSection.getString("mmoitems_id"));
        } else if (useRemainderSection.contains("ecoitem_id")) {
            result = new WrappedEcoItem(useRemainderSection.getString("ecoitem_id")).build();
        } else if (useRemainderSection.contains("minecraft_type")) {
            Material material = Material.getMaterial((String)useRemainderSection.getString("minecraft_type", "AIR"));
            if (material == null || material.isAir()) {
                return;
            }
            result = new ItemStack(material);
        } else {
            result = useRemainderSection.getItemStack("minecraft_item");
        }
        if (result != null) {
            result.setAmount(amount);
        }
        item.setUseRemainder(result);
    }

    private void parseToolComponent(ItemBuilder item, @NotNull ConfigurationSection toolSection) {
        ToolComponent toolComponent = new ItemStack(this.type).getItemMeta().getTool();
        toolComponent.setDamagePerBlock(Math.max(toolSection.getInt("damage_per_block", 1), 0));
        toolComponent.setDefaultMiningSpeed(Math.max((float)toolSection.getDouble("default_mining_speed", 1.0), 0.0f));
        for (Map ruleEntry : toolSection.getMapList("rules")) {
            HashSet<Tag> tags;
            HashSet<Material> materials;
            boolean correctForDrops;
            float speed;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            speed = NumberUtils.toFloat((String)String.valueOf(ruleEntry.get("speed")), (float)1.0f);
                            correctForDrops = Boolean.parseBoolean(String.valueOf(ruleEntry.get("correct_for_drops")));
                            materials = new HashSet<Material>();
                            tags = new HashSet<Tag>();
                            if (ruleEntry.containsKey("material")) {
                                try {
                                    Material material = Material.valueOf((String)String.valueOf(ruleEntry.get("material")));
                                    if (material.isBlock()) {
                                        materials.add(material);
                                    }
                                }
                                catch (Exception e) {
                                    Logs.logWarning("Error parsing rule-entry in " + this.section.getName());
                                    Logs.logWarning("Malformed \"material\"-section");
                                    if (!Settings.DEBUG.toBool().booleanValue()) break block19;
                                    e.printStackTrace();
                                }
                            }
                        }
                        if (ruleEntry.containsKey("materials")) {
                            try {
                                List materialIds = (List)ruleEntry.get("materials");
                                for (String materialId : materialIds) {
                                    Material material = Material.valueOf((String)materialId);
                                    if (!material.isBlock()) continue;
                                    materials.add(material);
                                }
                            }
                            catch (Exception e) {
                                Logs.logWarning("Error parsing rule-entry in " + this.section.getName());
                                Logs.logWarning("Malformed \"materials\"-section");
                                if (!Settings.DEBUG.toBool().booleanValue()) break block20;
                                e.printStackTrace();
                            }
                        }
                    }
                    if (ruleEntry.containsKey("tag")) {
                        try {
                            NamespacedKey tagKey = NamespacedKey.fromString((String)String.valueOf(ruleEntry.get("tag")));
                            if (tagKey != null) {
                                tags.add(Bukkit.getTag((String)"blocks", (NamespacedKey)tagKey, Material.class));
                            }
                        }
                        catch (Exception e) {
                            Logs.logWarning("Error parsing rule-entry in " + this.section.getName());
                            Logs.logWarning("Malformed \"tag\"-section");
                            if (!Settings.DEBUG.toBool().booleanValue()) break block21;
                            e.printStackTrace();
                        }
                    }
                }
                if (ruleEntry.containsKey("tags")) {
                    try {
                        for (String tagString : (List)ruleEntry.get("tags")) {
                            NamespacedKey tagKey = NamespacedKey.fromString((String)tagString);
                            if (tagKey == null) continue;
                            tags.add(Bukkit.getTag((String)"blocks", (NamespacedKey)tagKey, Material.class));
                        }
                    }
                    catch (Exception e) {
                        Logs.logWarning("Error parsing rule-entry in " + this.section.getName());
                        Logs.logWarning("Malformed \"material\"-section");
                        if (!Settings.DEBUG.toBool().booleanValue()) break block22;
                        e.printStackTrace();
                    }
                }
            }
            if (!materials.isEmpty()) {
                toolComponent.addRule(materials, Float.valueOf(speed), Boolean.valueOf(correctForDrops));
            }
            for (Tag tag : tags) {
                toolComponent.addRule(tag, Float.valueOf(speed), Boolean.valueOf(correctForDrops));
            }
        }
        item.setToolComponent(toolComponent);
    }

    private void parseEquippableComponent(ItemBuilder item, ConfigurationSection equippableSection) {
        EquippableComponent equippableComponent = new ItemStack(this.type).getItemMeta().getEquippable();
        String slot = equippableSection.getString("slot");
        try {
            equippableComponent.setSlot(EquipmentSlot.valueOf((String)slot));
        }
        catch (Exception e2) {
            Logs.logWarning("Error parsing equippable-component in %s...".formatted(this.section.getName()));
            Logs.logWarning("Invalid \"slot\"-value %s".formatted(slot));
            Logs.logWarning("Valid values are: %s".formatted(StringUtils.join((Object[])EquipmentSlot.values())));
            return;
        }
        List<EntityType> entityTypes = equippableSection.getStringList("allowed_entity_types").stream().map(e -> (EntityType)EnumUtils.getEnum(EntityType.class, (String)e)).toList();
        if (equippableSection.contains("allowed_entity_types")) {
            equippableComponent.setAllowedEntities(entityTypes.isEmpty() ? null : entityTypes);
        }
        if (equippableSection.contains("damage_on_hurt")) {
            equippableComponent.setDamageOnHurt(equippableSection.getBoolean("damage_on_hurt", true));
        }
        if (equippableSection.contains("dispensable")) {
            equippableComponent.setDispensable(equippableSection.getBoolean("dispensable", true));
        }
        if (equippableSection.contains("swappable")) {
            equippableComponent.setSwappable(equippableSection.getBoolean("swappable", true));
        }
        Optional.ofNullable(equippableSection.getString("model", null)).map(NamespacedKey::fromString).ifPresent(arg_0 -> ((EquippableComponent)equippableComponent).setModel(arg_0));
        Optional.ofNullable(equippableSection.getString("camera_overlay")).map(NamespacedKey::fromString).ifPresent(arg_0 -> ((EquippableComponent)equippableComponent).setCameraOverlay(arg_0));
        if (VersionUtil.isPaperServer() && equippableSection.contains("equip_sound")) {
            try {
                Optional.ofNullable(equippableSection.getString("equip_sound")).map(Key::key).map(key -> (Sound)Registry.SOUNDS.get(key)).ifPresent(arg_0 -> ((EquippableComponent)equippableComponent).setEquipSound(arg_0));
            }
            catch (NoSuchMethodError e3) {
                Logs.logWarning("Error setting equip_sound: Your server version doesn't support this feature.");
            }
        }
        item.setEquippableComponent(equippableComponent);
    }

    private void parseMiscOptions(ItemBuilder item) {
        if (this.section.getBoolean("injectId", true)) {
            item.setCustomTag(OraxenItems.ITEM_ID, PersistentDataType.STRING, this.section.getName());
        }
        ConfigurationSection section = this.mergeWithTemplateSection();
        this.oraxenMeta.setNoUpdate(section.getBoolean("no_auto_update", false));
        this.oraxenMeta.setDisableEnchanting(section.getBoolean("disable_enchanting", false));
        this.oraxenMeta.setExcludedFromInventory(section.getBoolean("excludeFromInventory", false));
        this.oraxenMeta.setExcludedFromCommands(section.getBoolean("excludeFromCommands", false));
    }

    private void parseVanillaSections(ItemBuilder item) {
        List attributes;
        ConfigurationSection section = this.mergeWithTemplateSection();
        if (section.contains("ItemFlags")) {
            List itemFlags = section.getStringList("ItemFlags");
            for (String itemFlag : itemFlags) {
                item.addItemFlags(ItemFlag.valueOf((String)itemFlag));
            }
        }
        if (section.contains("PotionEffects")) {
            List potionEffects = section.getList("PotionEffects");
            if (potionEffects == null) {
                return;
            }
            for (Map serializedPotionEffect : potionEffects) {
                PotionEffectType effect = PotionUtils.getEffectType(serializedPotionEffect.getOrDefault("type", ""));
                if (effect == null) {
                    return;
                }
                int duration = serializedPotionEffect.getOrDefault("duration", 60);
                int amplifier = serializedPotionEffect.getOrDefault("amplifier", 0);
                boolean ambient = serializedPotionEffect.getOrDefault("ambient", true);
                boolean particles = serializedPotionEffect.getOrDefault("particles", true);
                boolean icon = serializedPotionEffect.getOrDefault("icon", true);
                item.addPotionEffect(new PotionEffect(effect, duration, amplifier, ambient, particles, icon));
            }
        }
        if (section.contains("PersistentData")) {
            try {
                List dataHolder = section.getList("PersistentData");
                for (Map<String, String> attributeJson : dataHolder) {
                    String[] keyContent = ((String)((LinkedHashMap)attributeJson).get("key")).split(":");
                    Object persistentDataType = PersistentDataType.class.getDeclaredField((String)((LinkedHashMap)attributeJson).get("type")).get(null);
                    item.addCustomTag(new NamespacedKey(keyContent[0], keyContent[1]), (PersistentDataType)persistentDataType, ((LinkedHashMap)attributeJson).get("value"));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((attributes = section.getList("AttributeModifiers")) != null) {
            for (Map<String, String> attributeJson : attributes) {
                try {
                    attributeJson.putIfAbsent("uuid", UUID.randomUUID().toString());
                    attributeJson.putIfAbsent("name", "oraxen:modifier");
                    attributeJson.putIfAbsent("key", "oraxen:modifier");
                    AttributeModifier attributeModifier = AttributeModifier.deserialize(attributeJson);
                    Attribute attribute = AttributeWrapper.fromString((String)attributeJson.get("attribute"));
                    if (attribute != null) {
                        item.addAttributeModifiers(attribute, attributeModifier);
                        continue;
                    }
                    Logs.logWarning("Attribute not found for key: " + String.valueOf(attributeJson.get("attribute")) + " in item: " + section.getName());
                }
                catch (Exception e) {
                    Logs.logWarning("Error parsing AttributeModifiers in " + section.getName());
                    if (!Settings.DEBUG.toBool().booleanValue()) continue;
                    e.printStackTrace();
                }
            }
        }
        if (section.contains("Enchantments")) {
            ConfigurationSection enchantSection = section.getConfigurationSection("Enchantments");
            if (enchantSection == null) {
                return;
            }
            for (String enchant : enchantSection.getKeys(false)) {
                int level = enchantSection.getInt(enchant, 1);
                NamespacedKey namespacedKey = NamespacedKey.fromString((String)enchant);
                if (namespacedKey == null) {
                    Logs.logWarning("Invalid enchantment key: " + enchant + " in item: " + section.getName());
                    continue;
                }
                Enchantment enchantment = !VersionUtil.atOrAbove("1.21") ? EnchantmentWrapper.getByKey((NamespacedKey)namespacedKey) : (Enchantment)Registry.ENCHANTMENT.get(namespacedKey);
                if (enchantment == null) {
                    Logs.logWarning("Enchantment not found for key: " + enchant + " in item: " + section.getName());
                    continue;
                }
                item.addEnchant(enchantment, level);
            }
        }
    }

    private void parseOraxenSections(ItemBuilder item) {
        ConfigurationSection merged = this.mergeWithTemplateSection();
        ConfigurationSection mechanicsSection = merged.getConfigurationSection("Mechanics");
        if (mechanicsSection != null) {
            for (String mechanicID : mechanicsSection.getKeys(false)) {
                Mechanic mechanic;
                ConfigurationSection mechanicSection;
                MechanicFactory factory = MechanicsManager.getMechanicFactory(mechanicID);
                if (factory == null || (mechanicSection = mechanicsSection.getConfigurationSection(mechanicID)) == null || (mechanic = factory.parse(mechanicSection)) == null) continue;
                for (Function<ItemBuilder, ItemBuilder> itemModifier : mechanic.getItemModifiers()) {
                    item = itemModifier.apply(item);
                }
            }
        }
        if (this.oraxenMeta.hasPackInfos() && VersionUtil.atOrAbove("1.21.4")) {
            if (!item.hasItemModel()) {
                item.setItemModel(new NamespacedKey((Plugin)OraxenPlugin.get(), this.section.getName()));
            }
        } else {
            Integer customModelData;
            if (MODEL_DATAS_BY_ID.containsKey(this.section.getName())) {
                customModelData = MODEL_DATAS_BY_ID.get(this.section.getName()).getModelData();
            } else if (!item.hasItemModel()) {
                customModelData = ModelData.generateId(this.oraxenMeta.getModelName(), this.type);
                this.configUpdated = true;
                if (!Settings.DISABLE_AUTOMATIC_MODEL_DATA.toBool().booleanValue()) {
                    Optional.ofNullable(this.section.getConfigurationSection("Pack")).ifPresent(c -> c.set("custom_model_data", (Object)customModelData));
                }
            } else {
                customModelData = null;
            }
            if (customModelData != null) {
                item.setCustomModelData(customModelData);
                this.oraxenMeta.setCustomModelData(customModelData);
            }
        }
    }

    private ConfigurationSection mergeWithTemplateSection() {
        if (this.section == null || this.templateItem == null || this.templateItem.section == null) {
            return this.section;
        }
        ConfigurationSection merged = new YamlConfiguration().createSection(this.section.getName());
        OraxenYaml.copyConfigurationSection(this.templateItem.section, merged);
        OraxenYaml.copyConfigurationSection(this.section, merged);
        merged.set("injectId", (Object)true);
        return merged;
    }

    public boolean isConfigUpdated() {
        return this.configUpdated;
    }
}

