/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.blockstate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.blockstate.Variant;

public class MultiVariant
implements Examinable {
    private final List<Variant> variants;

    private MultiVariant(List<Variant> variants) {
        this.variants = Objects.requireNonNull(variants, "variants");
        this.validate();
    }

    private void validate() {
        if (this.variants.size() < 1) {
            throw new IllegalArgumentException("No variants provided!");
        }
    }

    public List<Variant> variants() {
        return this.variants;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"variants", this.variants));
    }

    public static MultiVariant of(List<Variant> variants) {
        return new MultiVariant(variants);
    }

    public static MultiVariant of(Variant ... variants) {
        return new MultiVariant(Arrays.asList(variants));
    }
}

