/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.protectionlib.compatibilities;

import io.th0rgal.protectionlib.ProtectionCompatibility;
import java.util.Optional;
import net.william278.huskclaims.api.BukkitHuskClaimsAPI;
import net.william278.huskclaims.api.HuskClaimsAPI;
import net.william278.huskclaims.libraries.cloplib.operation.OperationType;
import net.william278.huskclaims.position.Position;
import net.william278.huskclaims.trust.TrustLevel;
import net.william278.huskclaims.trust.Trustable;
import net.william278.huskclaims.user.OnlineUser;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HuskClaimCompat
extends ProtectionCompatibility {
    private final HuskClaimsAPI huskClaimsCommon = HuskClaimsAPI.getInstance();
    private final BukkitHuskClaimsAPI huskClaimsBukkit = BukkitHuskClaimsAPI.getInstance();

    public HuskClaimCompat(JavaPlugin mainPlugin, Plugin plugin) {
        super(mainPlugin, plugin);
    }

    @Override
    public boolean canBuild(Player player, Location target) {
        OnlineUser onlineUser = this.huskClaimsCommon.getOnlineUser(player.getUniqueId());
        Position position = this.huskClaimsBukkit.getPosition(target);
        Optional trustLevel = this.huskClaimsBukkit.getTrustLevelAt(position, (Trustable)onlineUser);
        return trustLevel.isEmpty() || ((TrustLevel)trustLevel.get()).getFlags().contains(OperationType.BLOCK_PLACE);
    }

    @Override
    public boolean canBreak(Player player, Location target) {
        OnlineUser onlineUser = this.huskClaimsCommon.getOnlineUser(player.getUniqueId());
        Position position = this.huskClaimsBukkit.getPosition(target);
        Optional trustLevel = this.huskClaimsBukkit.getTrustLevelAt(position, (Trustable)onlineUser);
        return trustLevel.isEmpty() || ((TrustLevel)trustLevel.get()).getFlags().contains(OperationType.BLOCK_BREAK);
    }

    @Override
    public boolean canInteract(Player player, Location target) {
        OnlineUser onlineUser = this.huskClaimsCommon.getOnlineUser(player.getUniqueId());
        Position position = this.huskClaimsBukkit.getPosition(target);
        OperationType operationType = target.getBlock().getType().isBlock() ? OperationType.BLOCK_INTERACT : OperationType.ENTITY_INTERACT;
        Optional trustLevel = this.huskClaimsBukkit.getTrustLevelAt(position, (Trustable)onlineUser);
        return trustLevel.isEmpty() || ((TrustLevel)trustLevel.get()).getFlags().contains(operationType);
    }

    @Override
    public boolean canUse(Player player, Location target) {
        OnlineUser onlineUser = this.huskClaimsCommon.getOnlineUser(player.getUniqueId());
        Position position = this.huskClaimsBukkit.getPosition(target);
        Optional trustLevel = this.huskClaimsBukkit.getTrustLevelAt(position, (Trustable)onlineUser);
        return trustLevel.isEmpty() || ((TrustLevel)trustLevel.get()).getFlags().contains(OperationType.BLOCK_INTERACT);
    }
}

