/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.music_disc.MusicDiscMechanic;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.util.Locale;
import java.util.logging.Level;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Jukebox;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class MusicDiscHelpers {
    public static final NamespacedKey MUSIC_DISC_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "music_disc");

    public static boolean hasMusicDisc(PersistentDataContainer pdc) {
        return pdc.has(MUSIC_DISC_KEY, DataType.ITEM_STACK);
    }

    public static ItemStack getMusicDisc(PersistentDataContainer pdc) {
        try {
            return (ItemStack)pdc.get(MUSIC_DISC_KEY, DataType.ITEM_STACK);
        }
        catch (Exception e) {
            OraxenPlugin.get().getLogger().log(Level.SEVERE, "Failed to read Music disc from pdc! " + pdc.toString(), e);
            return null;
        }
    }

    public static void setAndPlayMusicDisc(Entity entity, ItemStack record, float volume, float pitch) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (ItemUtils.isMusicDisc(record) && volume == 1.0f && pitch == 1.0f && NMSHandlers.getHandler().supportsJukeboxPlaying()) {
            NMSHandlers.getHandler().playJukeBoxSong(entity.getLocation(), record);
        } else {
            String song = MusicDiscHelpers.getSong(record);
            if (song == null) {
                return;
            }
            Key songKey = Key.key((String)song);
            Key soundId = Key.key((String)OraxenPlugin.get().getSoundManager().songKeyToSoundId(songKey));
            entity.getWorld().playSound(Sound.sound((Key)soundId, (Sound.Source)Sound.Source.RECORD, (float)volume, (float)pitch));
        }
        pdc.set(MUSIC_DISC_KEY, DataType.ITEM_STACK, (Object)record);
    }

    public static ItemStack stopJukeboxAt(Entity entity, float volume, float pitch) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        ItemStack record = MusicDiscHelpers.getMusicDisc(pdc);
        if (record == null) {
            return null;
        }
        pdc.remove(MUSIC_DISC_KEY);
        if (ItemUtils.isMusicDisc(record) && volume == 1.0f && pitch == 1.0f && NMSHandlers.getHandler().supportsJukeboxPlaying()) {
            NMSHandlers.getHandler().stopJukeBox(entity.getLocation());
        } else {
            String song = MusicDiscHelpers.getSong(record);
            if (song == null) {
                return record;
            }
            Key songKey = Key.key((String)song);
            Key soundId = Key.key((String)OraxenPlugin.get().getSoundManager().songKeyToSoundId(songKey));
            entity.getWorld().getNearbyEntities(entity.getLocation(), 64.0, 64.0, 64.0, e -> e instanceof Player).stream().map(Player.class::cast).forEach(player -> player.stopSound(SoundStop.namedOnSource((Key)soundId, (Sound.Source)Sound.Source.RECORD)));
        }
        return record;
    }

    public static boolean isVanillaJukeboxWithVanillaDisc(Block block) {
        if (!block.getType().equals((Object)Material.JUKEBOX)) {
            return false;
        }
        BlockState blockState = BlockHelpers.getState(block);
        if (blockState instanceof Jukebox) {
            Jukebox jukebox = (Jukebox)blockState;
            return ItemUtils.isMusicDisc(jukebox.getRecord());
        }
        return false;
    }

    @Nullable
    public static String getSong(ItemStack record, MechanicFactory factory) {
        MusicDiscMechanic musicDiscMechanic;
        if (ItemUtils.isInvalidItem(record)) {
            return null;
        }
        String song = MusicDiscHelpers.getSong(record);
        if (song != null) {
            return song;
        }
        String itemID = OraxenItems.getIdByItem(record);
        Mechanic mechanic = factory.getMechanic(itemID);
        if (mechanic instanceof MusicDiscMechanic && !(musicDiscMechanic = (MusicDiscMechanic)mechanic).hasNoSong()) {
            return musicDiscMechanic.getSong();
        }
        return null;
    }

    @Nullable
    public static String getSong(ItemStack record) {
        if (ItemUtils.isInvalidItem(record)) {
            return null;
        }
        if (VersionUtil.atOrAbove("1.21") && record.hasItemMeta() && record.getItemMeta().hasJukeboxPlayable()) {
            return record.getItemMeta().getJukeboxPlayable().getSongKey().toString();
        }
        if (record.getType().isRecord()) {
            return record.getType().toString().toLowerCase(Locale.ROOT).replaceFirst("music_disc_", "minecraft:music_disc.");
        }
        return null;
    }
}

