/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.lang.reflect.Method;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class InventoryUtils {
    private static Method getTitleMethod;
    private static Method titleMethod;
    private static Method topInventoryMethod;
    private static Method playerFromViewMethod;

    public static Component titleFromView(InventoryEvent event) {
        if (VersionUtil.atOrAbove("1.21")) {
            return event.getView().title();
        }
        try {
            return (Component)titleMethod.invoke((Object)event.getView(), new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return Component.empty();
        }
    }

    public static Player playerFromView(InventoryEvent event) {
        if (VersionUtil.atOrAbove("1.21")) {
            return (Player)event.getView().getPlayer();
        }
        try {
            return (Player)playerFromViewMethod.invoke((Object)event.getView(), new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static String getTitleFromView(InventoryEvent event) {
        if (VersionUtil.atOrAbove("1.21")) {
            return event.getView().getTitle();
        }
        try {
            return (String)getTitleMethod.invoke((Object)event.getView(), new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return "";
        }
    }

    public static Inventory topInventoryForPlayer(Player player) {
        if (VersionUtil.atOrAbove("1.21")) {
            return player.getOpenInventory().getTopInventory();
        }
        try {
            return (Inventory)topInventoryMethod.invoke((Object)player.getOpenInventory(), new Object[0]);
        }
        catch (Exception e) {
            if (Settings.DEBUG.toBool().booleanValue()) {
                e.printStackTrace();
            }
            return player.getInventory();
        }
    }

    static {
        try {
            getTitleMethod = InventoryView.class.getDeclaredMethod("getTitle", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            titleMethod = InventoryView.class.getDeclaredMethod("title", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            topInventoryMethod = InventoryView.class.getDeclaredMethod("getTopInventory", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            playerFromViewMethod = InventoryView.class.getDeclaredMethod("getPlayer", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

