/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.misc;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.misc.misc.MiscMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.misc.MiscMechanicFactory;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.Arrays;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MiscListener
implements Listener {
    public MiscListener(MiscMechanicFactory factory) {
        if (VersionUtil.isPaperServer()) {
            OraxenPlugin.get().getServer().getPluginManager().registerEvents((Listener)new PaperOnlyListeners(factory), (Plugin)OraxenPlugin.get());
        }
    }

    @EventHandler
    public void onHopperCompost(InventoryMoveItemEvent event) {
        Block hopper;
        Inventory source = event.getSource();
        if (source.getType() != InventoryType.HOPPER || event.getDestination().getType() != InventoryType.COMPOSTER) {
            return;
        }
        Block block = hopper = source.getLocation() != null ? source.getLocation().getBlock() : null;
        if (hopper == null || hopper.getType() != Material.HOPPER) {
            return;
        }
        Block composter = hopper.getRelative(BlockFace.DOWN);
        if (composter.getType() != Material.COMPOSTER) {
            return;
        }
        BlockData blockData = composter.getBlockData();
        if (!(blockData instanceof Levelled)) {
            return;
        }
        Levelled levelled = (Levelled)blockData;
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(event.getItem());
        if (mechanic == null || !mechanic.isCompostable()) {
            return;
        }
        if (levelled.getLevel() < levelled.getMaximumLevel()) {
            if (Math.random() <= 0.65) {
                levelled.setLevel(levelled.getLevel() + 1);
            }
            composter.setBlockData((BlockData)levelled);
            composter.getWorld().playEffect(composter.getLocation(), Effect.COMPOSTER_FILL_ATTEMPT, 0, 1);
            ItemStack item = event.getItem();
            item.setAmount(item.getAmount() - 1);
            event.setItem(item);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onCompost(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == null) {
            return;
        }
        if (item == null || block == null || block.getType() != Material.COMPOSTER) {
            return;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Levelled)) {
            return;
        }
        Levelled levelled = (Levelled)blockData;
        if (!ProtectionLib.canInteract(player, block.getLocation())) {
            return;
        }
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(item);
        if (mechanic == null || !mechanic.isCompostable()) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        event.setUseInteractedBlock(Event.Result.ALLOW);
        event.setUseItemInHand(Event.Result.ALLOW);
        if (levelled.getLevel() < levelled.getMaximumLevel()) {
            if (Math.random() <= 0.65) {
                levelled.setLevel(levelled.getLevel() + 1);
            }
            block.setBlockData((BlockData)levelled);
            block.getWorld().playEffect(block.getLocation(), Effect.COMPOSTER_FILL_ATTEMPT, 0, 1);
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.setAmount(item.getAmount() - 1);
            }
            Utils.swingHand(player, event.getHand());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStripLog(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        Player player = event.getPlayer();
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(item);
        if (block == null || !Tag.LOGS.isTagged((Keyed)block.getType())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || item == null) {
            return;
        }
        if (mechanic == null || !mechanic.canStripLogs()) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof Damageable) {
            short maxDurability;
            Damageable axeDurabilityMeta = (Damageable)itemMeta;
            int durability = axeDurabilityMeta.getDamage();
            if (durability + 1 <= (maxDurability = item.getType().getMaxDurability())) {
                axeDurabilityMeta.setDamage(durability + 1);
                item.setItemMeta((ItemMeta)axeDurabilityMeta);
            } else {
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                item.setType(Material.AIR);
            }
        }
        block.setType(this.getStrippedLog(block.getType()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPiglinAggro(EntityTargetLivingEntityEvent event) {
        if (!(event.getEntity() instanceof Piglin)) {
            return;
        }
        LivingEntity livingEntity = event.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EntityEquipment equipment = player.getEquipment();
        if (equipment == null) {
            return;
        }
        if (this.shouldPreventPiglinAggro(equipment.getItemInMainHand())) {
            event.setCancelled(true);
        }
        if (this.shouldPreventPiglinAggro(equipment.getItemInOffHand())) {
            event.setCancelled(true);
        }
        if (Arrays.stream(equipment.getArmorContents()).anyMatch(this::shouldPreventPiglinAggro)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemBurnFire(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FIRE && event.getCause() != EntityDamageEvent.DamageCause.FIRE_TICK) {
            return;
        }
        MiscMechanic mechanic = this.getMiscMechanic(event.getEntity());
        if (mechanic == null || mechanic.burnsInFire()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemBurn(EntityDamageByBlockEvent event) {
        MiscMechanic mechanic = this.getMiscMechanic(event.getEntity());
        if (mechanic == null) {
            return;
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (cause == EntityDamageEvent.DamageCause.CONTACT && !mechanic.breaksFromCactus()) {
            event.setCancelled(true);
        } else if (cause == EntityDamageEvent.DamageCause.LAVA && !mechanic.burnsInLava()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDisableVanillaInteraction(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(event.getItem());
        if (mechanic == null || !mechanic.isVanillaInteractionDisabled()) {
            return;
        }
        event.setUseItemInHand(Event.Result.DENY);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDisableItemConsume(PlayerItemConsumeEvent event) {
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(event.getItem());
        if (mechanic == null || !mechanic.isVanillaInteractionDisabled()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDisableBowShoot(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(event.getConsumable());
        if (mechanic == null || !mechanic.isVanillaInteractionDisabled()) {
            return;
        }
        event.setConsumeItem(false);
        event.setCancelled(true);
        player.updateInventory();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDisableHorseArmorEquip(InventoryClickEvent event) {
        ItemStack item;
        if (!(event.getInventory() instanceof HorseInventory)) {
            return;
        }
        if (event.getAction() == InventoryAction.PLACE_ALL && event.getClickedInventory() instanceof HorseInventory) {
            item = event.getCursor();
        } else if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && event.getClickedInventory() instanceof PlayerInventory) {
            item = event.getCurrentItem();
        } else {
            return;
        }
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(item);
        if (mechanic == null || !mechanic.isVanillaInteractionDisabled()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDisableHorseArmorEquip(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof Horse)) {
            return;
        }
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(item);
        if (mechanic == null || !mechanic.isVanillaInteractionDisabled()) {
            return;
        }
        if (item.getType().name().endsWith("_HORSE_ARMOR")) {
            event.setCancelled(true);
        }
    }

    private MiscMechanic getMiscMechanic(Entity entity) {
        if (!(entity instanceof Item)) {
            return null;
        }
        Item item = (Item)entity;
        ItemStack itemStack = item.getItemStack();
        String itemID = OraxenItems.getIdByItem(itemStack);
        if (itemID == null) {
            return null;
        }
        return MiscMechanicFactory.get().getMechanic(itemID);
    }

    private Material getStrippedLog(Material log) {
        return switch (log) {
            case Material.OAK_LOG -> Material.STRIPPED_OAK_LOG;
            case Material.SPRUCE_LOG -> Material.STRIPPED_SPRUCE_LOG;
            case Material.BIRCH_LOG -> Material.STRIPPED_BIRCH_LOG;
            case Material.JUNGLE_LOG -> Material.STRIPPED_JUNGLE_LOG;
            case Material.ACACIA_LOG -> Material.STRIPPED_ACACIA_LOG;
            case Material.DARK_OAK_LOG -> Material.STRIPPED_DARK_OAK_LOG;
            case Material.CRIMSON_STEM -> Material.STRIPPED_CRIMSON_STEM;
            case Material.WARPED_STEM -> Material.STRIPPED_WARPED_STEM;
            case Material.MANGROVE_LOG -> Material.STRIPPED_MANGROVE_LOG;
            case Material.OAK_WOOD -> Material.STRIPPED_OAK_WOOD;
            case Material.SPRUCE_WOOD -> Material.STRIPPED_SPRUCE_WOOD;
            case Material.BIRCH_WOOD -> Material.STRIPPED_BIRCH_WOOD;
            case Material.JUNGLE_WOOD -> Material.STRIPPED_JUNGLE_WOOD;
            case Material.ACACIA_WOOD -> Material.STRIPPED_ACACIA_WOOD;
            case Material.DARK_OAK_WOOD -> Material.STRIPPED_DARK_OAK_WOOD;
            case Material.CRIMSON_HYPHAE -> Material.STRIPPED_CRIMSON_HYPHAE;
            case Material.WARPED_HYPHAE -> Material.STRIPPED_WARPED_HYPHAE;
            case Material.MANGROVE_WOOD -> Material.STRIPPED_MANGROVE_WOOD;
            default -> null;
        };
    }

    private boolean shouldPreventPiglinAggro(ItemStack itemStack) {
        MiscMechanic mechanic = MiscMechanicFactory.get().getMechanic(OraxenItems.getIdByItem(itemStack));
        return mechanic != null && mechanic.piglinIgnoreWhenEquipped();
    }

    private record PaperOnlyListeners(MiscMechanicFactory factory) implements Listener
    {
    }
}

