/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.armor_effects;

import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.misc.armor_effects.ArmorEffect;
import io.th0rgal.oraxen.mechanics.provided.misc.armor_effects.ArmorEffectsFactory;
import io.th0rgal.oraxen.utils.PotionUtils;
import io.th0rgal.oraxen.utils.customarmor.ShaderArmorTextures;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorEffectsMechanic
extends Mechanic {
    public static final Set<Integer> ARMOR_SLOTS = Set.of(Integer.valueOf(36), Integer.valueOf(37), Integer.valueOf(38), Integer.valueOf(39));
    private final Set<ArmorEffect> armorEffects = new HashSet<ArmorEffect>();

    public ArmorEffectsMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        for (String effect : section.getKeys(false)) {
            ConfigurationSection effectSection = section.getConfigurationSection(effect);
            if (effectSection == null) continue;
            this.registersEffectFromSection(effectSection);
        }
    }

    public void registersEffectFromSection(ConfigurationSection section) {
        String type = section.getName().toLowerCase(Locale.ROOT);
        PotionEffectType effectType = PotionUtils.getEffectType(type);
        if (effectType == null) {
            Logs.logError("Invalid potion effect: " + section.getName() + ", in " + StringUtils.substringBefore((String)section.getCurrentPath(), (String)".") + "!");
            return;
        }
        int duration = section.getInt("duration", ArmorEffectsFactory.getInstance().getDelay());
        int amplifier = section.getInt("amplifier", 0);
        boolean ambient = section.getBoolean("ambient", false);
        boolean particles = section.getBoolean("particles", true);
        boolean icon = section.getBoolean("icon", true);
        boolean requiresFullSet = section.getBoolean("requires_full_set", false);
        PotionEffect potionEffect = new PotionEffect(effectType, duration, amplifier, ambient, particles, icon);
        this.armorEffects.add(new ArmorEffect(potionEffect, requiresFullSet));
    }

    public Set<ArmorEffect> getArmorEffects() {
        return this.armorEffects;
    }

    public static void addEffects(Player player) {
        for (int armorSlot : ARMOR_SLOTS) {
            ItemStack armorPiece = player.getInventory().getItem(armorSlot);
            ArmorEffectsMechanic mechanic = (ArmorEffectsMechanic)ArmorEffectsFactory.getInstance().getMechanic(armorPiece);
            if (mechanic == null) continue;
            HashSet<PotionEffect> finalArmorEffects = new HashSet<PotionEffect>();
            for (ArmorEffect armorEffect : mechanic.getArmorEffects()) {
                if (armorEffect.requiresFullSet()) {
                    boolean hasFullSet = ARMOR_SLOTS.stream().filter(s -> s != armorSlot).allMatch(slot -> {
                        ItemStack armor = player.getInventory().getItem(slot.intValue());
                        return armor != null && ShaderArmorTextures.isSameArmorType(armorPiece, armor);
                    });
                    if (!hasFullSet) continue;
                    finalArmorEffects.add(armorEffect.getEffect());
                    continue;
                }
                finalArmorEffects.add(armorEffect.getEffect());
            }
            player.addPotionEffects(finalArmorEffects);
        }
    }
}

