/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.cosmetic.aura;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.AuraMechanic;
import io.th0rgal.oraxen.mechanics.provided.cosmetic.aura.AuraMechanicFactory;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class AuraMechanicListener
implements Listener {
    private final AuraMechanicFactory factory;
    private final Map<Player, AuraMechanic> registeredPlayers;

    public AuraMechanicListener(AuraMechanicFactory factory) {
        this.factory = factory;
        this.registeredPlayers = new HashMap<Player, AuraMechanic>();
    }

    public void enable(Player player, AuraMechanic mechanic) {
        this.disable(player);
        mechanic.add(player);
        this.registeredPlayers.put(player, mechanic);
    }

    public void disable(Player player) {
        AuraMechanic aura = this.registeredPlayers.remove(player);
        if (aura != null) {
            aura.remove(player);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void unregister(PlayerQuitEvent event) {
        this.disable(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void register(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack item = inventory.getItem(event.getNewSlot());
        String itemID = OraxenItems.getIdByItem(item);
        if (this.factory.isNotImplementedIn(itemID)) {
            this.disable(player);
        } else {
            this.enable(player, (AuraMechanic)this.factory.getMechanic(itemID));
        }
    }
}

