/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.texture;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.base.Writable;
import team.unnamed.creative.metadata.Metadata;
import team.unnamed.creative.metadata.Metadatable;
import team.unnamed.creative.metadata.animation.AnimationMeta;
import team.unnamed.creative.metadata.texture.TextureMeta;
import team.unnamed.creative.metadata.villager.VillagerMeta;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;
import team.unnamed.creative.texture.TextureImpl;

@ApiStatus.NonExtendable
public interface Texture
extends ResourcePackPart,
Keyed,
Examinable,
Metadatable {
    @NotNull
    public static Texture texture(@NotNull Key key, @NotNull Writable data) {
        return Texture.texture(key, data, Metadata.empty());
    }

    @NotNull
    public static Texture texture(@NotNull Key key, @NotNull Writable data, @NotNull Metadata meta) {
        return new TextureImpl(key, data, meta);
    }

    @NotNull
    public static Builder texture() {
        return new TextureImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Texture of(@NotNull Key key, @NotNull Writable data) {
        return Texture.of(key, data, Metadata.empty());
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Texture of(@NotNull Key key, @NotNull Writable data, @NotNull Metadata meta) {
        return new TextureImpl(key, data, meta);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Builder builder() {
        return new TextureImpl.BuilderImpl();
    }

    @NotNull
    public Key key();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Texture key(@NotNull Key key) {
        return this.toBuilder().key(key).build();
    }

    @NotNull
    public Writable data();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Texture data(@NotNull Writable data) {
        return this.toBuilder().data(data).build();
    }

    @Override
    @NotNull
    public Metadata meta();

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public Texture meta(@NotNull Metadata meta) {
        return this.toBuilder().meta(meta).build();
    }

    @Contract(value="-> new")
    @NotNull
    default public Builder toBuilder() {
        return Texture.builder().key(this.key()).data(this.data()).meta(this.meta());
    }

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.texture(this);
    }

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @Nullable
        public Key key();

        @Contract(value="_ -> this")
        @NotNull
        public Builder data(@NotNull Writable var1);

        @Nullable
        public Writable data();

        @Contract(value="_ -> this")
        @NotNull
        public Builder meta(@NotNull Metadata var1);

        @NotNull
        public Metadata meta();

        @Contract(value="_ -> this")
        @NotNull
        default public Builder animationMeta(@NotNull AnimationMeta animationMeta) {
            return this.meta(this.meta().toBuilder().add(animationMeta).build());
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder villagerMeta(@NotNull VillagerMeta villagerMeta) {
            return this.meta(this.meta().toBuilder().add(villagerMeta).build());
        }

        @NotNull
        default public Builder textureMeta(@NotNull TextureMeta textureMeta) {
            return this.meta(this.meta().toBuilder().add(textureMeta).build());
        }

        @NotNull
        public Texture build();
    }
}

