/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.base;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Vector2Float
implements Examinable,
Iterable<Float> {
    public static final Vector2Float ZERO = new Vector2Float(0.0f, 0.0f);
    public static final Vector2Float ONE = new Vector2Float(1.0f, 1.0f);
    private final float x;
    private final float y;

    public Vector2Float(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector2Float add(@NotNull Vector2Float value) {
        return new Vector2Float(this.x + value.x, this.y + value.y);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector2Float subtract(@NotNull Vector2Float value) {
        return new Vector2Float(this.x - value.x, this.y - value.y);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector2Float multiply(@NotNull Vector2Float value) {
        return new Vector2Float(this.x * value.x, this.y * value.y);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector2Float multiply(float value) {
        return new Vector2Float(this.x * value, this.y * value);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector2Float divide(@NotNull Vector2Float value) {
        return new Vector2Float(this.x / value.x, this.y / value.y);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Vector2Float divide(float value) {
        return new Vector2Float(this.x / value, this.y / value);
    }

    @Contract(value="-> new", pure=true)
    public float @NotNull [] toArray() {
        return new float[]{this.x, this.y};
    }

    @Override
    @NotNull
    public Iterator<Float> iterator() {
        return Arrays.asList(Float.valueOf(this.x), Float.valueOf(this.y)).iterator();
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"x", (float)this.x), ExaminableProperty.of((String)"y", (float)this.y));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vector2Float that = (Vector2Float)o;
        return this.x == that.x && this.y == that.y;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.x), Float.valueOf(this.y));
    }
}

