/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.base;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.base.KeyPattern;

final class KeyPatternImpl
implements KeyPattern {
    static final KeyPattern ANY = new KeyPatternImpl(null, null);
    @Nullable
    private final Pattern namespace;
    @Nullable
    private final Pattern value;

    KeyPatternImpl(@Nullable Pattern namespace, @Nullable Pattern value) {
        this.namespace = namespace;
        this.value = value;
    }

    @Override
    @Nullable
    public Pattern namespace() {
        return this.namespace;
    }

    @Override
    @Nullable
    public Pattern value() {
        return this.value;
    }

    @Override
    public boolean test(@NotNull Key key) {
        Objects.requireNonNull(key, "key");
        return !(this.namespace != null && !this.namespace.matcher(key.namespace()).matches() || this.value != null && !this.value.matcher(key.value()).matches());
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"namespace", (Object)this.namespace), ExaminableProperty.of((String)"value", (Object)this.value));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeyPatternImpl that = (KeyPatternImpl)other;
        return KeyPatternImpl.patternEquals(this.namespace, that.namespace) && KeyPatternImpl.patternEquals(this.value, that.value);
    }

    private static boolean patternEquals(@Nullable Pattern a, @Nullable Pattern b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return a.pattern().equals(b.pattern());
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.value);
    }
}

