/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.actions;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.stream.Collectors;
import me.gabytm.util.actions.actions.Action;
import me.gabytm.util.actions.actions.ActionMeta;
import me.gabytm.util.actions.actions.ActionParser;
import me.gabytm.util.actions.actions.Context;
import me.gabytm.util.actions.actions.implementations.DataAction;
import me.gabytm.util.actions.components.ComponentParser;
import me.gabytm.util.actions.placeholders.PlaceholderManager;
import me.gabytm.util.actions.tasks.DefaultTaskProcessor;
import me.gabytm.util.actions.tasks.TaskProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionManager {
    protected final PlaceholderManager placeholderManager = new PlaceholderManager();
    protected final ComponentParser componentParser = new ComponentParser(this.placeholderManager);
    protected final ActionParser actionParser = new ActionParser(this);
    protected final SplittableRandom random = new SplittableRandom();
    protected final Table<String, Class<?>, Action.Supplier<?>> actions = HashBasedTable.create();
    protected final TaskProcessor taskProcessor;
    protected final double maxChance;

    public ActionManager(@Nullable TaskProcessor taskProcessor, double maxChance) {
        this.taskProcessor = taskProcessor == null ? new DefaultTaskProcessor() : taskProcessor;
        this.maxChance = maxChance + 1.0;
    }

    @Nullable
    protected final <T> Action<T> createAction(@NotNull Class<T> clazz, @NotNull String id, @NotNull ActionMeta<T> meta) {
        Action.Supplier supplier = (Action.Supplier)this.actions.get((Object)id.toLowerCase(), clazz);
        if (supplier == null) {
            return null;
        }
        return supplier.run(meta);
    }

    @NotNull
    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    @NotNull
    public ComponentParser getComponentParser() {
        return this.componentParser;
    }

    public <T> boolean isRegistered(@NotNull Class<T> clazz, @NotNull String id) {
        return this.actions.get((Object)id.toLowerCase(), clazz) != null;
    }

    public <T> void register(@NotNull Class<T> clazz, @NotNull String id, @NotNull Action.Supplier<T> action) {
        this.actions.put((Object)id.toLowerCase(), clazz, action);
    }

    public <T> void registerDefaults(@NotNull Class<T> clazz) {
        this.register(clazz, "data", DataAction::new);
    }

    @NotNull
    public <T> List<Action<T>> parse(@NotNull Class<T> clazz, @NotNull Collection<String> actions) {
        return actions.stream().map(it -> this.actionParser.parseAction(clazz, (String)it)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public <T> void run(@NotNull T t, @NotNull List<Action<T>> actions, boolean async, @NotNull Map<String, Object> data) {
        Context context = new Context(actions, data);
        for (Action action : context) {
            ActionMeta<T> meta = action.getMeta();
            if (meta.hasChance() && this.random.nextDouble(0.0, this.maxChance) > meta.getChance()) continue;
            Runnable task = () -> action.run(t, context);
            if (meta.hasDelay()) {
                if (async) {
                    this.taskProcessor.runAsync(task, meta.getDelay());
                    continue;
                }
                this.taskProcessor.runSync(task, meta.getDelay());
                continue;
            }
            if (async) {
                this.taskProcessor.runAsync(task);
                continue;
            }
            this.taskProcessor.runSync(task);
        }
    }

    public <T> void run(@NotNull T t, @NotNull List<Action<T>> actions, boolean async) {
        this.run(t, actions, async, new HashMap<String, Object>());
    }
}

