/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Message;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.Tooltip;
import java.util.Collection;
import java.util.function.Function;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class BukkitTooltip<S>
extends Tooltip<S> {
    protected BukkitTooltip(S object, Message tooltip) {
        super(object, tooltip);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateBaseComponents(Function<S, BaseComponent[]> tooltipGenerator, S ... suggestions) {
        return BukkitTooltip.generate(tooltipGenerator, BukkitTooltip::ofBaseComponents, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateBaseComponents(Function<S, BaseComponent[]> tooltipGenerator, Collection<S> suggestions) {
        return BukkitTooltip.generate(tooltipGenerator, BukkitTooltip::ofBaseComponents, suggestions);
    }

    @SafeVarargs
    public static <S> Collection<Tooltip<S>> generateAdventureComponents(Function<S, ComponentLike> tooltipGenerator, S ... suggestions) {
        return BukkitTooltip.generate(tooltipGenerator, BukkitTooltip::ofAdventureComponent, suggestions);
    }

    public static <S> Collection<Tooltip<S>> generateAdventureComponents(Function<S, ComponentLike> tooltipGenerator, Collection<S> suggestions) {
        return BukkitTooltip.generate(tooltipGenerator, BukkitTooltip::ofAdventureComponent, suggestions);
    }

    public static <S> Tooltip<S> ofBaseComponents(S object, BaseComponent ... tooltip) {
        return BukkitTooltip.ofMessage(object, BukkitTooltip.messageFromBaseComponents(tooltip));
    }

    public static <S> Tooltip<S> ofAdventureComponent(S object, ComponentLike tooltip) {
        return BukkitTooltip.ofMessage(object, BukkitTooltip.messageFromAdventureComponent(tooltip));
    }

    public static Message messageFromBaseComponents(BaseComponent ... components) {
        return CommandAPIBukkit.get().generateMessageFromJson(ComponentSerializer.toString((BaseComponent[])components));
    }

    public static Message messageFromAdventureComponent(ComponentLike component) {
        return CommandAPIBukkit.get().generateMessageFromJson((String)GsonComponentSerializer.gson().serialize(component.asComponent()));
    }
}

