/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockInteractEvent;
import io.th0rgal.oraxen.api.events.stringblock.OraxenStringBlockPlaceEvent;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanicFactory;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.PluginUtils;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import io.th0rgal.oraxen.utils.breaker.HardnessModifier;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.lang3.Range;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class StringBlockMechanicListener
implements Listener {
    public StringBlockMechanicListener() {
        if (PluginUtils.isEnabled("ProtocolLib")) {
            BreakerSystem.MODIFIERS.add(this.getHardnessModifier());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void callInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.NOTE_BLOCK) {
            return;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
        if (mechanic == null) {
            return;
        }
        if (!EventUtils.callEvent(new OraxenStringBlockInteractEvent(mechanic, event.getPlayer(), event.getItem(), event.getHand(), block, event.getBlockFace()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlacingString(PlayerInteractEvent event) {
        if (event.getItem() == null || event.getItem().getType() != Material.STRING) {
            return;
        }
        if (StringBlockMechanicFactory.getInstance().disableVanillaString) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlacingString(BlockPlaceEvent event) {
        Block placedBlock = event.getBlockPlaced();
        if (placedBlock.getType() != Material.TRIPWIRE || OraxenItems.exists(event.getItemInHand())) {
            return;
        }
        placedBlock.setBlockData(Material.TRIPWIRE.createBlockData(), false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onLimitedPlacing(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        BlockFace blockFace = event.getBlockFace();
        ItemStack item = event.getItem();
        if (item == null || block == null || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(OraxenItems.getIdByItem(item));
        if (mechanic == null || !mechanic.hasLimitedPlacing()) {
            return;
        }
        if (!event.getPlayer().isSneaking() && BlockHelpers.isInteractable(block)) {
            return;
        }
        LimitedPlacing limitedPlacing = mechanic.getLimitedPlacing();
        Block belowPlaced = block.getRelative(blockFace).getRelative(BlockFace.DOWN);
        if (limitedPlacing.isNotPlacableOn(block, blockFace)) {
            event.setCancelled(true);
        } else if (limitedPlacing.isRadiusLimited()) {
            LimitedPlacing.RadiusLimitation radiusLimitation = limitedPlacing.getRadiusLimitation();
            int rad = radiusLimitation.getRadius();
            int amount = radiusLimitation.getAmount();
            int count = 0;
            for (int x = -rad; x <= rad; ++x) {
                for (int y = -rad; y <= rad; ++y) {
                    for (int z = -rad; z <= rad; ++z) {
                        StringBlockMechanic relativeMechanic = OraxenBlocks.getStringMechanic(block.getRelative(x, y, z));
                        if (relativeMechanic == null || !relativeMechanic.getItemID().equals(mechanic.getItemID())) continue;
                        ++count;
                    }
                }
            }
            if (count >= amount) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.ALLOW) {
            if (!limitedPlacing.checkLimitedMechanic(belowPlaced)) {
                event.setCancelled(true);
            }
        } else if (limitedPlacing.getType() == LimitedPlacing.LimitedPlacingType.DENY && limitedPlacing.checkLimitedMechanic(belowPlaced)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPrePlacingCustomBlock(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = event.getItem();
        String itemID = OraxenItems.getIdByItem(item);
        Block placedAgainst = event.getClickedBlock();
        Player player = event.getPlayer();
        StringBlockMechanic mechanic = StringBlockMechanicFactory.getInstance().getMechanic(itemID);
        if (mechanic == null || placedAgainst == null) {
            return;
        }
        if (!event.getPlayer().isSneaking() && BlockHelpers.isInteractable(placedAgainst)) {
            return;
        }
        if (item != null && item.getType().isBlock() && !StringBlockMechanicFactory.getInstance().isNotImplementedIn(itemID)) {
            for (BlockFace face : BlockFace.values()) {
                Block relative;
                if (!face.isCartesian() || face.getModZ() != 0 || OraxenBlocks.getNoteBlockMechanic(relative = placedAgainst.getRelative(face)) == null || OraxenBlocks.getStringMechanic(relative) == null || item.getItemMeta() instanceof BlockStateMeta || item.getType().hasGravity() || item.getType().toString().endsWith("SLAB")) continue;
                this.makePlayerPlaceBlock(player, event.getHand(), item, placedAgainst, event.getBlockFace(), Bukkit.createBlockData((Material)item.getType()));
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), Runnable2 -> StringBlockMechanicListener.fixClientsideUpdate(placedAgainst.getLocation()), 1L);
            }
        }
        int customVariation = mechanic.getCustomVariation();
        if (mechanic.hasRandomPlace()) {
            List<String> randomList = mechanic.getRandomPlaceBlock();
            String randomBlock = randomList.get(new Random().nextInt(randomList.size()));
            customVariation = StringBlockMechanicFactory.getInstance().getMechanic(randomBlock).getCustomVariation();
        }
        BlockData data = StringBlockMechanicFactory.createTripwireData(customVariation);
        this.makePlayerPlaceBlock(player, event.getHand(), item, placedAgainst, event.getBlockFace(), data);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        EquipmentSlot hand = event.getHand();
        if (hand == null || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (block == null || block.getType() != Material.TRIPWIRE) {
            return;
        }
        StringBlockMechanic stringBlockMechanic = OraxenBlocks.getStringMechanic(block);
        if (stringBlockMechanic == null) {
            return;
        }
        if (!EventUtils.callEvent(new OraxenStringBlockInteractEvent(stringBlockMechanic, event.getPlayer(), event.getItem(), event.getHand(), block, event.getBlockFace()))) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBreakingCustomBlock(BlockBreakEvent event) {
        Block block = event.getBlock();
        Block blockAbove = block.getRelative(BlockFace.UP);
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        Player player = event.getPlayer();
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
        if (mechanic != null) {
            event.setCancelled(true);
            OraxenBlocks.remove(block.getLocation(), player);
            event.setDropItems(false);
            return;
        }
        StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(blockBelow);
        if (block.getType() == Material.TRIPWIRE && mechanicBelow != null && mechanicBelow.isTall()) {
            event.setCancelled(true);
            OraxenBlocks.remove(blockBelow.getLocation(), player);
            event.setDropItems(false);
            return;
        }
        if (blockAbove.getType() == Material.TRIPWIRE && OraxenBlocks.isOraxenStringBlock(blockAbove)) {
            OraxenBlocks.remove(blockAbove.getLocation(), player);
        }
    }

    @EventHandler
    public void onExplosionDestroy(EntityExplodeEvent event) {
        List<Block> blockList = event.blockList().stream().filter(block -> block.getType().equals((Object)Material.TRIPWIRE)).toList();
        blockList.forEach(block -> {
            StringBlockMechanic stringBlockMechanic = OraxenBlocks.getStringMechanic(block);
            if (stringBlockMechanic == null) {
                return;
            }
            Block blockAbove = block.getRelative(BlockFace.UP);
            Block blockBelow = block.getRelative(BlockFace.DOWN);
            if (block.getType() == Material.TRIPWIRE) {
                StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(blockBelow);
                if (OraxenBlocks.isOraxenStringBlock(block)) {
                    OraxenBlocks.remove(block.getLocation(), null, true);
                    event.blockList().remove(block);
                } else if (mechanicBelow != null && mechanicBelow.isTall()) {
                    OraxenBlocks.remove(blockBelow.getLocation(), null, true);
                    event.blockList().remove(block);
                }
            } else {
                if (!OraxenBlocks.isOraxenStringBlock(blockAbove)) {
                    return;
                }
                OraxenBlocks.remove(blockAbove.getLocation(), null, true);
                event.blockList().remove(block);
            }
        });
    }

    @EventHandler
    public void onBlockExplosionDestroy(BlockExplodeEvent event) {
        List<Block> blockList = event.blockList().stream().filter(block -> block.getType().equals((Object)Material.TRIPWIRE)).toList();
        blockList.forEach(block -> {
            StringBlockMechanic stringBlockMechanic = OraxenBlocks.getStringMechanic(block);
            if (stringBlockMechanic == null) {
                return;
            }
            Block blockAbove = block.getRelative(BlockFace.UP);
            Block blockBelow = block.getRelative(BlockFace.DOWN);
            if (block.getType() == Material.TRIPWIRE) {
                StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(blockBelow);
                if (OraxenBlocks.isOraxenStringBlock(block)) {
                    OraxenBlocks.remove(block.getLocation(), null, true);
                    event.blockList().remove(block);
                } else if (mechanicBelow != null && mechanicBelow.isTall()) {
                    OraxenBlocks.remove(blockBelow.getLocation(), null, true);
                    event.blockList().remove(block);
                }
            } else {
                if (!OraxenBlocks.isOraxenStringBlock(blockAbove)) {
                    return;
                }
                OraxenBlocks.remove(blockAbove.getLocation(), null, true);
                event.blockList().remove(block);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWaterUpdate(BlockFromToEvent event) {
        Block changed = event.getToBlock();
        Block changedBelow = changed.getRelative(BlockFace.DOWN);
        if (!event.getBlock().isLiquid() || changed.getType() != Material.TRIPWIRE) {
            return;
        }
        event.setCancelled(true);
        StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(changedBelow);
        if (OraxenBlocks.isOraxenStringBlock(changed)) {
            OraxenBlocks.remove(changed.getLocation(), null, true);
        } else if (mechanicBelow != null && mechanicBelow.isTall()) {
            OraxenBlocks.remove(changedBelow.getLocation(), null, true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onMiddleClick(InventoryCreativeEvent event) {
        if (event.getClick() != ClickType.CREATIVE) {
            return;
        }
        Player player = (Player)event.getInventory().getHolder();
        if (player == null) {
            return;
        }
        ItemStack cursor = event.getCursor();
        if (cursor == null || cursor.getType() != Material.STRING) {
            return;
        }
        RayTraceResult rayTraceResult = player.rayTraceBlocks(6.0);
        if (rayTraceResult == null) {
            return;
        }
        Block block = rayTraceResult.getHitBlock();
        if (block == null) {
            return;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block);
        if (mechanic == null) {
            StringBlockMechanic mechanicBelow = OraxenBlocks.getStringMechanic(block.getRelative(BlockFace.DOWN));
            if (mechanicBelow == null || !mechanicBelow.isTall()) {
                return;
            }
            mechanic = mechanicBelow;
        }
        ItemStack item = OraxenItems.getItemById(mechanic.getItemID()).build();
        for (int i = 0; i <= 8; ++i) {
            ItemStack hotbarItem = player.getInventory().getItem(i);
            if (hotbarItem == null || !Objects.equals(OraxenItems.getIdByItem(hotbarItem), mechanic.getItemID())) continue;
            player.getInventory().setHeldItemSlot(i);
            event.setCancelled(true);
            return;
        }
        event.setCursor(item);
    }

    @EventHandler(ignoreCancelled=true)
    public void updateLightOnBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
    }

    private HardnessModifier getHardnessModifier() {
        return new HardnessModifier(this){

            @Override
            public boolean isTriggered(Player player, Block block, ItemStack tool) {
                if (block.getType() != Material.TRIPWIRE) {
                    return false;
                }
                StringBlockMechanic tripwireMechanic = OraxenBlocks.getStringMechanic(block);
                return tripwireMechanic != null && tripwireMechanic.hasHardness();
            }

            @Override
            public void breakBlock(Player player, Block block, ItemStack tool) {
                block.setType(Material.AIR);
            }

            @Override
            public long getPeriod(Player player, Block block, ItemStack tool) {
                StringBlockMechanic tripwireMechanic = OraxenBlocks.getStringMechanic(block);
                if (tripwireMechanic == null) {
                    return 0L;
                }
                long period = tripwireMechanic.getHardness();
                double modifier = 1.0;
                if (tripwireMechanic.getDrop().canDrop(tool)) {
                    modifier *= 0.4;
                    int diff = tripwireMechanic.getDrop().getDiff(tool);
                    if (diff >= 1) {
                        modifier *= Math.pow(0.9, diff);
                    }
                }
                return (long)((double)period * modifier);
            }
        };
    }

    private void makePlayerPlaceBlock(Player player, EquipmentSlot hand, ItemStack item, Block placedAgainst, BlockFace face, BlockData newData) {
        Material type = placedAgainst.getType();
        Block target = BlockHelpers.isReplaceable(type) ? placedAgainst : placedAgainst.getRelative(face);
        if (!BlockHelpers.isReplaceable(target.getType())) {
            return;
        }
        StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(newData);
        Block blockAbove = target.getRelative(BlockFace.UP);
        BlockData oldData = target.getBlockData();
        BlockData oldDataAbove = blockAbove.getBlockData();
        target.setBlockData(newData);
        BlockPlaceEvent blockPlaceEvent = new BlockPlaceEvent(target, target.getState(), placedAgainst, item, player, true, hand);
        Range worldHeightRange = Range.between((Comparable)Integer.valueOf(target.getWorld().getMinHeight()), (Comparable)Integer.valueOf(target.getWorld().getMaxHeight() - 1));
        if (mechanic != null && mechanic.isTall()) {
            if (!BlockHelpers.REPLACEABLE_BLOCKS.contains(blockAbove.getType()) || !worldHeightRange.contains((Object)blockAbove.getY())) {
                blockPlaceEvent.setCancelled(true);
            } else {
                blockAbove.setType(Material.TRIPWIRE);
            }
        }
        if (!ProtectionLib.canBuild((Player)player, (Location)target.getLocation())) {
            blockPlaceEvent.setCancelled(true);
        }
        if (!worldHeightRange.contains((Object)target.getY())) {
            blockPlaceEvent.setCancelled(true);
        }
        if (!EventUtils.callEvent((Event)blockPlaceEvent) || !blockPlaceEvent.canBuild()) {
            target.setBlockData(oldData);
            if (mechanic != null && mechanic.isTall()) {
                blockAbove.setBlockData(oldDataAbove);
            }
            return;
        }
        if (mechanic != null) {
            OraxenBlocks.place(mechanic.getItemID(), target.getLocation());
            OraxenStringBlockPlaceEvent oraxenPlaceEvent = new OraxenStringBlockPlaceEvent(mechanic, target, player, item, hand);
            if (!EventUtils.callEvent(oraxenPlaceEvent)) {
                target.setBlockData(oldData);
                if (mechanic.isTall()) {
                    blockAbove.setBlockData(oldDataAbove);
                }
                return;
            }
            if (player.getGameMode() != GameMode.CREATIVE) {
                item.setAmount(item.getAmount() - 1);
            }
            Utils.swingHand(player, hand);
        } else {
            target.setType(Material.AIR);
            BlockHelpers.correctAllBlockStates(placedAgainst, player, hand, face, item, newData);
        }
        if (VersionUtil.isPaperServer()) {
            target.getWorld().sendGameEvent((Entity)player, GameEvent.BLOCK_PLACE, target.getLocation().toVector());
        }
    }

    public static void fixClientsideUpdate(Location loc) {
        List<Entity> players = Objects.requireNonNull(loc.getWorld()).getNearbyEntities(loc, 20.0, 20.0, 20.0).stream().filter(entity -> entity.getType() == EntityType.PLAYER).toList();
        for (double x = loc.getX() - 10.0; x < loc.getX() + 10.0; x += 1.0) {
            for (double y = loc.getY() - 4.0; y < loc.getY() + 4.0; y += 1.0) {
                for (double z = loc.getZ() - 10.0; z < loc.getZ() + 10.0; z += 1.0) {
                    if (loc.getBlock().getType() != Material.TRIPWIRE) continue;
                    Location newLoc = new Location(loc.getWorld(), x, y, z);
                    for (Entity e : players) {
                        ((Player)e).sendBlockChange(newLoc, newLoc.getBlock().getBlockData());
                    }
                }
            }
        }
    }

    public static class StringBlockMechanicPhysicsListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void tripwireEvent(BlockPhysicsEvent event) {
            Block block = event.getBlock();
            if (event.getChangedType() != Material.TRIPWIRE) {
                return;
            }
            if (event.getSourceBlock() == event.getBlock()) {
                return;
            }
            if (OraxenBlocks.isOraxenStringBlock(block)) {
                event.setCancelled(true);
                return;
            }
            for (BlockFace f : BlockFace.values()) {
                Block changed;
                if (!f.isCartesian() || f.getModY() != 0 || f == BlockFace.SELF || (changed = block.getRelative(f)).getType() != Material.TRIPWIRE || OraxenBlocks.isOraxenStringBlock(changed)) continue;
                BlockData data = changed.getBlockData().clone();
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> changed.setBlockData(data, false), 1L);
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onPistonPush(BlockPistonExtendEvent event) {
            List<Block> tripwireList = event.getBlocks().stream().filter(block -> block.getType().equals((Object)Material.TRIPWIRE)).toList();
            for (Block block2 : tripwireList) {
                StringBlockMechanic mechanic = OraxenBlocks.getStringMechanic(block2);
                if (mechanic == null) continue;
                block2.setType(Material.AIR, false);
                if (mechanic.hasLight()) {
                    mechanic.getLight().removeBlockLight(block2);
                }
                mechanic.getDrop().spawns(block2.getLocation(), new ItemStack(Material.AIR));
            }
        }

        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
        public void onBreak(BlockBreakEvent event) {
            Block block = event.getBlock();
            Block blockAbove = block.getRelative(BlockFace.UP);
            Player player = event.getPlayer();
            for (BlockFace face : BlockFace.values()) {
                if (face == BlockFace.SELF && !face.isCartesian()) continue;
                if (block.getType() == Material.TRIPWIRE || block.getType() == Material.NOTE_BLOCK || block.getType() == Material.BARRIER && OraxenFurniture.isFurniture(block)) break;
                if (block.getRelative(face).getType() != Material.TRIPWIRE) continue;
                if (player.getGameMode() != GameMode.CREATIVE) {
                    block.breakNaturally(player.getInventory().getItemInMainHand(), true);
                } else {
                    block.setType(Material.AIR);
                }
                if (BlockHelpers.isReplaceable(blockAbove.getType())) {
                    blockAbove.breakNaturally(true);
                }
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), Runnable2 -> StringBlockMechanicListener.fixClientsideUpdate(block.getLocation()), 1L);
            }
        }
    }

    public static class StringBlockMechanicPaperListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onEnteringTripwire(EntityInsideBlockEvent event) {
            if (event.getBlock().getType() == Material.TRIPWIRE) {
                event.setCancelled(true);
            }
        }
    }
}

