/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.base.CubeFace;
import team.unnamed.creative.model.ElementFace;
import team.unnamed.creative.texture.TextureUV;

final class ElementFaceImpl
implements ElementFace {
    @Nullable
    private final TextureUV uv;
    private final String texture;
    @Nullable
    private final CubeFace cullFace;
    private final int rotation;
    private final int tintIndex;

    ElementFaceImpl(@Nullable TextureUV uv, @NotNull String texture, @Nullable CubeFace cullFace, int rotation, int tintIndex) {
        this.uv = uv;
        this.texture = Objects.requireNonNull(texture, "texture");
        this.cullFace = cullFace;
        this.rotation = rotation;
        this.tintIndex = tintIndex;
        this.validate();
    }

    private void validate() {
        if (this.rotation % 90 != 0 || this.rotation < 0 || this.rotation > 270) {
            throw new IllegalArgumentException("Rotation must be a positive multiple of 90");
        }
    }

    @Override
    @Nullable
    public TextureUV uv0() {
        return this.uv;
    }

    @Override
    @NotNull
    public String texture() {
        return this.texture;
    }

    @Override
    @Nullable
    public CubeFace cullFace() {
        return this.cullFace;
    }

    @Override
    public int rotation() {
        return this.rotation;
    }

    @Override
    public int tintIndex() {
        return this.tintIndex;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"uv", (Object)this.uv), ExaminableProperty.of((String)"texture", (String)this.texture), ExaminableProperty.of((String)"cullFace", (Object)((Object)this.cullFace)), ExaminableProperty.of((String)"rotation", (int)this.rotation), ExaminableProperty.of((String)"tintIndex", (int)this.tintIndex));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementFaceImpl that = (ElementFaceImpl)o;
        return this.rotation == that.rotation && Objects.equals(this.uv, that.uv) && this.texture.equals(that.texture) && this.cullFace == that.cullFace && this.tintIndex == that.tintIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uv, this.texture, this.cullFace, this.rotation, this.tintIndex});
    }

    static final class BuilderImpl
    implements ElementFace.Builder {
        private TextureUV uv;
        private String texture;
        private CubeFace cullFace;
        private int rotation = 0;
        private int tintIndex = -1;

        BuilderImpl() {
        }

        @Override
        @NotNull
        public ElementFace.Builder uv(@Nullable TextureUV uv) {
            this.uv = uv;
            return this;
        }

        @Override
        @NotNull
        public ElementFace.Builder texture(@NotNull String texture) {
            this.texture = Objects.requireNonNull(texture, "texture");
            return this;
        }

        @Override
        @NotNull
        public ElementFace.Builder cullFace(@Nullable CubeFace cullFace) {
            this.cullFace = cullFace;
            return this;
        }

        @Override
        @NotNull
        public ElementFace.Builder rotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        @Override
        @NotNull
        public ElementFace.Builder tintIndex(int tintIndex) {
            this.tintIndex = tintIndex;
            return this;
        }

        @Override
        @NotNull
        public ElementFace build() {
            return new ElementFaceImpl(this.uv, this.texture, this.cullFace, this.rotation, this.tintIndex);
        }
    }
}

