/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.font;

import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.examination.Examinable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.unnamed.creative.font.FontImpl;
import team.unnamed.creative.font.FontProvider;
import team.unnamed.creative.overlay.ResourceContainer;
import team.unnamed.creative.part.ResourcePackPart;

@ApiStatus.NonExtendable
public interface Font
extends ResourcePackPart,
Keyed,
Examinable {
    public static final Key MINECRAFT_DEFAULT = Key.key((String)"default");
    public static final Key MINECRAFT_ALT = Key.key((String)"alt");
    public static final Key MINECRAFT_ILLAGERALT = Key.key((String)"illageralt");
    public static final Key MINECRAFT_UNIFORM = Key.key((String)"uniform");

    @NotNull
    public static Font font(@NotNull Key key, @NotNull List<FontProvider> providers) {
        return new FontImpl(key, providers);
    }

    @NotNull
    public static Font font(@NotNull Key key, FontProvider ... providers) {
        return Font.of(key, Arrays.asList(providers));
    }

    @NotNull
    public static Builder font() {
        return new FontImpl.BuilderImpl();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Font of(@NotNull Key key, @NotNull List<FontProvider> providers) {
        return Font.font(key, providers);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    @NotNull
    public static Font of(@NotNull Key key, FontProvider ... providers) {
        return Font.font(key, Arrays.asList(providers));
    }

    @NotNull
    public Key key();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Font key(@NotNull Key var1);

    @NotNull
    public List<FontProvider> providers();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public Font providers(@NotNull List<FontProvider> var1);

    @NotNull
    default public Builder toBuilder() {
        return Font.font().key(this.key()).providers(this.providers());
    }

    @Override
    default public void addTo(@NotNull ResourceContainer resourceContainer) {
        resourceContainer.font(this);
    }

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder key(@NotNull Key var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder providers(@NotNull List<FontProvider> var1);

        @NotNull
        public Builder providers(FontProvider ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder addProvider(@NotNull FontProvider var1);

        @NotNull
        public Font build();
    }
}

