/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.packs.DataPack;

public abstract class OraxenDatapack {
    protected static final World defaultWorld = (World)Bukkit.getWorlds().get(0);
    protected final File datapackFolder;
    protected final JsonObject datapackMeta = new JsonObject();
    protected final boolean isFirstInstall;
    protected final boolean datapackEnabled;
    protected final String name;

    protected OraxenDatapack(String name, String description, int packFormat) {
        this.datapackFolder = defaultWorld.getWorldFolder().toPath().resolve("datapacks/" + name).toFile();
        JsonObject data = new JsonObject();
        data.addProperty("description", description);
        data.addProperty("pack_format", (Number)packFormat);
        this.datapackMeta.add("pack", (JsonElement)data);
        this.name = name;
        this.isFirstInstall = this.isFirstInstall();
        this.datapackEnabled = this.isDatapackEnabled();
    }

    protected void writeMCMeta() {
        try {
            File packMeta = this.datapackFolder.toPath().resolve("pack.mcmeta").toFile();
            packMeta.createNewFile();
            FileUtils.writeStringToFile((File)packMeta, (String)this.datapackMeta.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clearOldDataPack() {
        try {
            FileUtils.deleteDirectory((File)this.datapackFolder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected abstract Key getDatapackKey();

    public abstract void generateAssets(List<VirtualFile> var1);

    protected boolean isFirstInstall() {
        return Bukkit.getDataPackManager().getDataPacks().stream().filter(d -> d.getKey() != null).noneMatch(d -> this.getDatapackKey().equals((Object)Key.key((String)d.getKey().toString())));
    }

    protected boolean isDatapackEnabled() {
        for (DataPack dataPack : Bukkit.getDataPackManager().getEnabledDataPacks(defaultWorld)) {
            if (dataPack.getKey() == null || !dataPack.getKey().equals((Object)this.getDatapackKey())) continue;
            return true;
        }
        for (DataPack dataPack : Bukkit.getDataPackManager().getDisabledDataPacks(defaultWorld)) {
            if (dataPack.getKey() == null || !dataPack.getKey().equals((Object)this.getDatapackKey())) continue;
            return true;
        }
        return false;
    }

    protected void enableDatapack(boolean enabled) {
        if (VersionUtil.isPaperServer()) {
            Bukkit.getDatapackManager().getPacks().stream().filter(d -> d.getName() == this.name).findFirst().ifPresent(d -> d.setEnabled(enabled));
        }
    }

    public boolean isEnabled() {
        return this.datapackEnabled;
    }

    public boolean isFirstTime() {
        return this.isFirstInstall;
    }
}

