/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DisplayEntityProperties {
    private Integer viewRange;
    private final Display.Brightness brightness;
    private ItemDisplay.ItemDisplayTransform displayTransform;
    private Display.Billboard trackingRotation;
    private Float shadowStrength;
    private Float shadowRadius;
    private Integer interpolationDuration;
    private Integer interpolationDelay;
    private final float displayWidth;
    private final float displayHeight;
    private final Vector3f scale;

    public DisplayEntityProperties() {
        this.displayWidth = 0.0f;
        this.displayHeight = 0.0f;
        this.displayTransform = ItemDisplay.ItemDisplayTransform.NONE;
        this.scale = null;
        this.shadowRadius = null;
        this.shadowStrength = null;
        this.brightness = null;
        this.trackingRotation = null;
        this.viewRange = null;
    }

    public DisplayEntityProperties(ConfigurationSection configSection) {
        String itemID = configSection.getParent().getParent().getParent().getName();
        this.viewRange = configSection.getInt("view_range");
        this.interpolationDuration = configSection.getInt("interpolation_duration");
        this.interpolationDelay = configSection.getInt("interpolation_delay");
        this.shadowStrength = Float.valueOf((float)configSection.getDouble("shadow_strength"));
        this.shadowRadius = Float.valueOf((float)configSection.getDouble("shadow_radius"));
        this.displayWidth = (float)configSection.getDouble("displayWidth", 0.0);
        this.displayHeight = (float)configSection.getDouble("displayHeight", 0.0);
        this.scale = configSection.isConfigurationSection("scale") ? new Vector3f((float)configSection.getDouble("scale.x", 1.0), (float)configSection.getDouble("scale.y", 1.0), (float)configSection.getDouble("scale.z", 1.0)) : null;
        if (this.viewRange == 0) {
            this.viewRange = null;
        }
        if (this.interpolationDuration == 0) {
            this.interpolationDuration = null;
        }
        if (this.interpolationDelay == 0) {
            this.interpolationDelay = null;
        }
        if (this.shadowStrength.floatValue() == 0.0f) {
            this.shadowStrength = null;
        }
        if (this.shadowRadius.floatValue() == 0.0f) {
            this.shadowRadius = null;
        }
        try {
            this.displayTransform = ItemDisplay.ItemDisplayTransform.valueOf((String)configSection.getString("display_transform", ItemDisplay.ItemDisplayTransform.NONE.name()));
        }
        catch (IllegalArgumentException e) {
            Logs.logError("Use of illegal ItemDisplayTransform in furniture: <gold>" + itemID);
            Logs.logWarning("Allowed ones are: <gold>" + String.valueOf(Arrays.stream(ItemDisplay.ItemDisplayTransform.values()).map(Enum::name).toList()));
            Logs.logWarning("Setting transform to NONE for furniture: <gold>" + itemID);
            this.displayTransform = ItemDisplay.ItemDisplayTransform.NONE;
        }
        try {
            this.trackingRotation = Display.Billboard.valueOf((String)configSection.getString("tracking_rotation", Display.Billboard.FIXED.name()));
        }
        catch (IllegalArgumentException e) {
            Logs.logError("Use of illegal tracking-rotation in " + itemID + " furniture.");
            Logs.logError("Allowed ones are: " + String.valueOf(Arrays.stream(ItemDisplay.ItemDisplayTransform.values()).toList().stream().map(Enum::name)));
            Logs.logWarning("Set tracking-rotation to FIXED for " + itemID);
            this.trackingRotation = Display.Billboard.FIXED;
        }
        ConfigurationSection brightnessSection = configSection.getConfigurationSection("brightness");
        this.brightness = brightnessSection != null ? new Display.Brightness(brightnessSection.getInt("block_light", 0), brightnessSection.getInt("sky_light", 0)) : null;
    }

    public boolean hasSpecifiedViewRange() {
        return this.viewRange != null;
    }

    public int getViewRange() {
        return this.viewRange;
    }

    public boolean hasInterpolationDuration() {
        return this.interpolationDuration != null;
    }

    public int getInterpolationDuration() {
        return this.interpolationDuration;
    }

    public boolean hasInterpolationDelay() {
        return this.interpolationDelay != null;
    }

    public int getInterpolationDelay() {
        return this.interpolationDelay;
    }

    public boolean hasBrightness() {
        return this.brightness != null;
    }

    public Display.Brightness getBrightness() {
        return this.brightness;
    }

    public ItemDisplay.ItemDisplayTransform getDisplayTransform() {
        return this.displayTransform;
    }

    public boolean hasTrackingRotation() {
        return this.trackingRotation != null;
    }

    public Display.Billboard getTrackingRotation() {
        return this.trackingRotation;
    }

    public boolean hasShadowStrength() {
        return this.shadowStrength != null;
    }

    public float getShadowStrength() {
        return this.shadowStrength.floatValue();
    }

    public boolean hasShadowRadius() {
        return this.shadowRadius != null;
    }

    public float getShadowRadius() {
        return this.shadowRadius.floatValue();
    }

    public float getDisplayWidth() {
        return this.displayWidth;
    }

    public float getDisplayHeight() {
        return this.displayHeight;
    }

    public boolean hasScale() {
        return this.scale != null;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public boolean ensureSameDisplayProperties(@NotNull Entity entity) {
        if (!(entity instanceof ItemDisplay)) {
            return false;
        }
        ItemDisplay itemDisplay = (ItemDisplay)entity;
        itemDisplay.setItemDisplayTransform(this.displayTransform);
        itemDisplay.setBillboard(Objects.requireNonNullElse(this.trackingRotation, Display.Billboard.FIXED));
        itemDisplay.setBrightness(Objects.requireNonNullElse(this.brightness, new Display.Brightness(0, 0)));
        itemDisplay.setShadowRadius(Objects.requireNonNullElse(this.shadowRadius, Float.valueOf(0.0f)).floatValue());
        itemDisplay.setShadowStrength(Objects.requireNonNullElse(this.shadowStrength, Float.valueOf(0.0f)).floatValue());
        itemDisplay.setViewRange((float)Objects.requireNonNullElse(this.viewRange, 0).intValue());
        itemDisplay.setInterpolationDuration(Objects.requireNonNullElse(this.interpolationDuration, 0).intValue());
        itemDisplay.setInterpolationDelay(Objects.requireNonNullElse(this.interpolationDelay, 0).intValue());
        itemDisplay.getTransformation().getScale().set((Vector3fc)Objects.requireNonNullElse(this.scale, new Vector3f(1.0f, 1.0f, 1.0f)));
        return true;
    }
}

