/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.compatibilities.provided.mmoitems;

import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.PluginUtils;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.ItemTier;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.template.MMOItemTemplate;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class WrappedMMOItem {
    private final Type type;
    private final String id;
    private final int level;
    private final ItemTier tier;

    public WrappedMMOItem(ConfigurationSection section) {
        if (!PluginUtils.isEnabled("MMOItems")) {
            Message.MMOITEMS_NOT_INSTALLED.log(new TagResolver[0]);
            this.type = null;
            this.id = null;
            this.level = 0;
            this.tier = null;
        } else {
            this.type = MMOItems.plugin.getTypes().get(section.getString("type"));
            this.id = section.getString("id");
            if (!MMOItems.plugin.getTemplates().hasTemplate(this.type, this.id)) {
                Message.MMOITEMS_LOADING_ITEM_FAILED.log(AdventureUtils.tagResolver("id", this.id));
                Message.MMOITEMS_MISSING_TEMPLATE.log(new TagResolver[0]);
            }
            this.level = section.getInt("level", 1);
            String tierId = section.getString("tier");
            this.tier = tierId != null && MMOItems.plugin.getTiers().has(tierId) ? MMOItems.plugin.getTiers().get(tierId) : null;
        }
    }

    public WrappedMMOItem(Type type, String id, int level, ItemTier tier) {
        this.type = type;
        this.id = id;
        this.level = level;
        this.tier = tier;
    }

    public WrappedMMOItem(Type type, String id) {
        this.type = type;
        this.id = id;
        this.level = 1;
        this.tier = null;
    }

    private MMOItemTemplate getTemplate() {
        if (MMOItems.plugin.getTemplates().hasTemplate(this.type, this.id)) {
            return MMOItems.plugin.getTemplates().getTemplate(this.type, this.id);
        }
        Message.MMOITEMS_LOADING_ITEM_FAILED.log(AdventureUtils.tagResolver("id", this.id));
        Message.MMOITEMS_MISSING_TEMPLATE.log(new TagResolver[0]);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack build() {
        if (PluginUtils.isEnabled("MMOItems")) {
            MMOItemTemplate template = this.getTemplate();
            if (template != null) return template.newBuilder().build().newBuilder().build();
            Message.MMOITEMS_LOADING_ITEM_FAILED.log(AdventureUtils.tagResolver("id", this.id));
            Message.MMOITEMS_MISSING_ITEM.log(new TagResolver[0]);
            return null;
        } else {
            Message.MMOITEMS_MISSING_PLUGIN.log(new TagResolver[0]);
        }
        return null;
    }
}

