/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.creative.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import team.unnamed.creative.model.Element;
import team.unnamed.creative.model.ItemOverride;
import team.unnamed.creative.model.ItemTransform;
import team.unnamed.creative.model.Model;
import team.unnamed.creative.model.ModelTextures;

final class ModelImpl
implements Model {
    private final Key key;
    private final Key parent;
    private final boolean ambientOcclusion;
    private final Map<ItemTransform.Type, ItemTransform> display;
    private final ModelTextures textures;
    private final Model.GuiLight guiLight;
    private final List<Element> elements;
    private final List<ItemOverride> overrides;

    ModelImpl(@NotNull Key key, @Nullable Key parent, boolean ambientOcclusion, @NotNull Map<ItemTransform.Type, ItemTransform> display, @NotNull ModelTextures textures, @Nullable Model.GuiLight guiLight, @NotNull List<Element> elements, @NotNull List<ItemOverride> overrides) {
        this.key = Objects.requireNonNull(key, "key");
        this.parent = parent;
        this.ambientOcclusion = ambientOcclusion;
        this.display = Objects.requireNonNull(display, "display");
        this.textures = Objects.requireNonNull(textures, "textures");
        this.guiLight = guiLight;
        this.elements = Objects.requireNonNull(elements, "elements");
        this.overrides = Objects.requireNonNull(overrides, "oveerrides");
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    @Nullable
    public Key parent() {
        return this.parent;
    }

    @Override
    public boolean ambientOcclusion() {
        return this.ambientOcclusion;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<ItemTransform.Type, ItemTransform> display() {
        return this.display;
    }

    @Override
    @NotNull
    public ModelTextures textures() {
        return this.textures;
    }

    @Override
    @Nullable
    public Model.GuiLight guiLight() {
        return this.guiLight;
    }

    @Override
    @NotNull
    public @Unmodifiable List<Element> elements() {
        return this.elements;
    }

    @Override
    @NotNull
    public List<ItemOverride> overrides() {
        return this.overrides;
    }

    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"key", (Object)this.key), ExaminableProperty.of((String)"parent", (Object)this.parent), ExaminableProperty.of((String)"ambientocclusion", (boolean)this.ambientOcclusion), ExaminableProperty.of((String)"display", this.display), ExaminableProperty.of((String)"textures", (Object)this.textures), ExaminableProperty.of((String)"guiLight", (Object)((Object)this.guiLight)), ExaminableProperty.of((String)"elements", this.elements), ExaminableProperty.of((String)"overrides", this.overrides));
    }

    @NotNull
    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelImpl that = (ModelImpl)o;
        return this.key.equals(that.key) && this.ambientOcclusion == that.ambientOcclusion && Objects.equals(this.parent, that.parent) && this.display.equals(that.display) && this.textures.equals(that.textures) && this.guiLight == that.guiLight && this.elements.equals(that.elements) && this.overrides.equals(that.overrides);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.parent, this.ambientOcclusion, this.display, this.textures, this.guiLight, this.elements, this.overrides});
    }

    static final class BuilderImpl
    implements Model.Builder {
        private Key key;
        private Key parent;
        private boolean ambientOcclusion = true;
        private Map<ItemTransform.Type, ItemTransform> display = new LinkedHashMap<ItemTransform.Type, ItemTransform>();
        private ModelTextures textures = ModelTextures.EMPTY;
        private Model.GuiLight guiLight;
        private List<Element> elements = new ArrayList<Element>();
        private List<ItemOverride> overrides = new ArrayList<ItemOverride>();

        BuilderImpl() {
        }

        @Override
        @NotNull
        public Model.Builder key(@NotNull Key key) {
            this.key = Objects.requireNonNull(key, "key");
            return this;
        }

        @Override
        @NotNull
        public Model.Builder parent(@Nullable Key parent) {
            this.parent = parent;
            return this;
        }

        @Override
        @NotNull
        public Model.Builder ambientOcclusion(boolean ambientOcclusion) {
            this.ambientOcclusion = ambientOcclusion;
            return this;
        }

        @Override
        @NotNull
        public Model.Builder display(@NotNull Map<ItemTransform.Type, ItemTransform> display) {
            Objects.requireNonNull(display, "display");
            this.display = new LinkedHashMap<ItemTransform.Type, ItemTransform>(display);
            return this;
        }

        @Override
        @NotNull
        public Model.Builder textures(@NotNull ModelTextures textures) {
            this.textures = Objects.requireNonNull(textures, "textures");
            return this;
        }

        @Override
        @NotNull
        public Model.Builder guiLight(@Nullable Model.GuiLight guiLight) {
            this.guiLight = guiLight;
            return this;
        }

        @Override
        @NotNull
        public Model.Builder elements(@NotNull List<Element> elements) {
            Objects.requireNonNull(elements, "elements");
            this.elements = new ArrayList<Element>(elements);
            return this;
        }

        @Override
        @NotNull
        public Model.Builder addElement(@NotNull Element element) {
            Objects.requireNonNull(element, "element");
            this.elements.add(element);
            return this;
        }

        @Override
        @NotNull
        public Model.Builder overrides(@NotNull List<ItemOverride> overrides) {
            Objects.requireNonNull(overrides, "overrides");
            this.overrides = new ArrayList<ItemOverride>(overrides);
            return this;
        }

        @Override
        @NotNull
        public Model.Builder addOverride(@NotNull ItemOverride override) {
            Objects.requireNonNull(override, "override");
            this.overrides.add(override);
            return this;
        }

        @Override
        @NotNull
        public Model build() {
            return new ModelImpl(this.key, this.parent, this.ambientOcclusion, this.display, this.textures, this.guiLight, this.elements, this.overrides);
        }
    }
}

