/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.farming.bigmining;

import io.th0rgal.oraxen.mechanics.provided.farming.bigmining.BigMiningMechanic;
import io.th0rgal.oraxen.mechanics.provided.farming.bigmining.BigMiningMechanicFactory;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class BigMiningMechanicListener
implements Listener {
    private final BigMiningMechanicFactory factory;
    private int blocksToProcess = 0;

    public BigMiningMechanicListener(BigMiningMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.blocksToProcess > 0) {
            --this.blocksToProcess;
            return;
        }
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, 5);
        BigMiningMechanic mechanic = (BigMiningMechanic)this.factory.getMechanic(item);
        if (mechanic == null || lastTwoTargetBlocks.size() < 2) {
            return;
        }
        Block nearestBlock = (Block)lastTwoTargetBlocks.get(0);
        Block secondBlock = (Block)lastTwoTargetBlocks.get(1);
        BlockFace blockFace = secondBlock.getFace(nearestBlock);
        Location secondMinusNearest = secondBlock.getLocation().subtract(nearestBlock.getLocation());
        int modifier = secondMinusNearest.getBlockX() + secondMinusNearest.getBlockY() + secondMinusNearest.getBlockZ();
        Location initialLocation = event.getBlock().getLocation();
        for (double relativeX = (double)(-mechanic.getRadius()); relativeX <= (double)mechanic.getRadius(); relativeX += 1.0) {
            for (double relativeY = (double)(-mechanic.getRadius()); relativeY <= (double)mechanic.getRadius(); relativeY += 1.0) {
                for (double relativeDepth = 0.0; relativeDepth < (double)mechanic.getDepth(); relativeDepth += 1.0) {
                    Location tempLocation = this.transpose(initialLocation, blockFace, relativeX, relativeY, relativeDepth * (double)modifier);
                    if (tempLocation.equals((Object)initialLocation)) continue;
                    this.breakBlock(player, tempLocation.getBlock(), item);
                }
            }
        }
        this.blocksToProcess = 0;
    }

    private void breakBlock(Player player, Block block, ItemStack itemStack) {
        if (block.isLiquid() || BlockHelpers.UNBREAKABLE_BLOCKS.contains(block.getType()) || !ProtectionLib.canBreak(player, block.getLocation())) {
            return;
        }
        ++this.blocksToProcess;
        BlockBreakEvent event = new BlockBreakEvent(block, player);
        if (!this.factory.callEvents() || !EventUtils.callEvent((Event)event)) {
            return;
        }
        if (event.isDropItems()) {
            if (VersionUtil.isPaperServer()) {
                block.breakNaturally(itemStack, true);
            } else {
                block.breakNaturally();
            }
        } else {
            block.setType(Material.AIR);
        }
    }

    private Location transpose(Location loc, BlockFace face, double relX, double relY, double relativeDepth) {
        loc = loc.clone();
        return switch (face) {
            case BlockFace.WEST, BlockFace.EAST -> loc.add(relativeDepth, relX, relY);
            case BlockFace.UP, BlockFace.DOWN -> loc.add(relX, relativeDepth, relY);
            default -> loc.add(relX, relY, relativeDepth);
        };
    }
}

