/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_20_0_1;

import com.github.stefvanschie.inventoryframework.abstraction.EnchantingTableInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_20_0_1.util.TextHolderUtil;
import java.lang.reflect.Field;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantingTableInventoryImpl
extends EnchantingTableInventory {
    public EnchantingTableInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 2) {
            throw new IllegalArgumentException("The amount of items for an enchanting table should be 2, but is '" + itemAmount + "'");
        }
        aig serverPlayer = this.getServerPlayer(player);
        sw message = TextHolderUtil.toComponent(title);
        ContainerEnchantingTableImpl containerEnchantmentTable = new ContainerEnchantingTableImpl(serverPlayer, items, message);
        serverPlayer.bR = containerEnchantmentTable;
        int id = containerEnchantmentTable.j;
        serverPlayer.c.a((uo)new wo(id, cck.m, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        hn nmsItems = hn.a((Object)cfz.b, (Object[])new cfz[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1])});
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        cfz cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ajb playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((uo)new vk(containerId, state, nmsItems, cursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, cfz.b));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull byo nmsPlayer) {
        return nmsPlayer.bR.j;
    }

    @NotNull
    @Contract(pure=true)
    private ajb getPlayerConnection(@NotNull aig serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private aig getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerEnchantingTableImpl
    extends cbx {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field enchantSlotsField;

        public ContainerEnchantingTableImpl(@Nullable aig serverPlayer, @NotNull ItemStack[] items, sw title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fN());
            this.player = serverPlayer.getBukkitEntity();
            this.setTitle(title);
            try {
                this.enchantSlotsField = cbx.class.getDeclaredField("n");
                this.enchantSlotsField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            try {
                bdq input = (bdq)this.enchantSlotsField.get((Object)this);
                input.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
                input.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                try {
                    CraftInventoryEnchanting inventory = new CraftInventoryEnchanting((bdq)this.enchantSlotsField.get((Object)this)){

                        @NotNull
                        @Contract(pure=true)
                        public InventoryHolder getHolder() {
                            return EnchantingTableInventoryImpl.this.inventoryHolder;
                        }
                    };
                    this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (cbf)this);
                }
                catch (IllegalAccessException exception) {
                    exception.printStackTrace();
                }
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable byo nmsPlayer) {
            return true;
        }

        public void a(bdq container) {
        }

        public void b(byo nmsPlayer) {
        }
    }
}

