/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.sound;

import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.pack.generation.OraxenDatapack;
import io.th0rgal.oraxen.sound.CustomSound;
import io.th0rgal.oraxen.utils.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class JukeboxDatapack
extends OraxenDatapack {
    public static final Key DATAPACK_KEY = Key.key((String)"minecraft:file/oraxen_jukebox");
    private final Collection<CustomSound> jukeboxSounds;

    public JukeboxDatapack(Collection<CustomSound> jukeboxSounds) {
        super("oraxen_jukebox", "Datapack for Oraxen's Custom Jukebox Songs", 18);
        this.jukeboxSounds = jukeboxSounds;
    }

    @Override
    protected Key getDatapackKey() {
        return DATAPACK_KEY;
    }

    @Override
    public void generateAssets(List<VirtualFile> output) {
        if (this.jukeboxSounds.isEmpty()) {
            return;
        }
        this.datapackFolder.toPath().resolve("data/oraxen/jukebox_song").toFile().mkdirs();
        this.writeMCMeta();
        this.writeJukeboxSongs();
        if (this.isFirstInstall || !this.datapackEnabled) {
            Message.DATAPACK_GENERATED.send((CommandSender)Bukkit.getConsoleSender(), TagResolver.resolver((TagResolver[])new TagResolver[]{Placeholder.parsed((String)"datapack_name", (String)"Jukebox")}));
        }
        this.enableDatapack(true);
    }

    private void writeJukeboxSongs() {
        for (CustomSound sound : this.jukeboxSounds) {
            File songFile = this.datapackFolder.toPath().resolve("data/oraxen/jukebox_song/" + sound.getName() + ".json").toFile();
            try {
                songFile.createNewFile();
                FileUtils.writeStringToFile((File)songFile, (String)sound.toJukeboxJson().toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

