/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import com.jeff_media.morepersistentdatatypes.DataType;
import com.jeff_media.persistentdataserializer.PersistentDataSerializer;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class ItemUpdater
implements Listener {
    private static final NamespacedKey IF_UUID = Objects.requireNonNull(NamespacedKey.fromString((String)"oraxen:if-uuid"));
    private static final NamespacedKey MF_GUI = Objects.requireNonNull(NamespacedKey.fromString((String)"oraxen:mf-gui"));

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!Settings.UPDATE_ITEMS.toBool().booleanValue()) {
            return;
        }
        PlayerInventory inventory = event.getPlayer().getInventory();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack oldItem = inventory.getItem(i);
            ItemStack newItem = ItemUpdater.updateItem(oldItem);
            if (oldItem == null || oldItem.equals((Object)newItem)) continue;
            inventory.setItem(i, newItem);
        }
    }

    @EventHandler
    public void onPlayerPickUp(EntityPickupItemEvent event) {
        ItemStack newItem;
        if (!Settings.UPDATE_ITEMS.toBool().booleanValue()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        ItemStack oldItem = event.getItem().getItemStack();
        if (oldItem.equals((Object)(newItem = ItemUpdater.updateItem(oldItem)))) {
            return;
        }
        event.getItem().setItemStack(newItem);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemEnchant(PrepareItemEnchantEvent event) {
        String id = OraxenItems.getIdByItem(event.getItem());
        ItemBuilder builder = OraxenItems.getItemById(id);
        if (builder == null || !builder.hasOraxenMeta()) {
            return;
        }
        if (builder.getOraxenMeta().isDisableEnchanting()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onItemEnchant(PrepareAnvilEvent event) {
        ItemStack item = event.getInventory().getItem(0);
        ItemStack result = event.getResult();
        String id = OraxenItems.getIdByItem(item);
        ItemBuilder builder = OraxenItems.getItemById(id);
        if (builder == null || !builder.hasOraxenMeta()) {
            return;
        }
        if (builder.getOraxenMeta().isDisableEnchanting()) {
            if (result == null || item == null) {
                return;
            }
            if (!result.getEnchantments().equals(item.getEnchantments())) {
                event.setResult(null);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUseMaxDamageItem(BlockBreakEvent event) {
        Damageable damageable;
        Player player = event.getPlayer();
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        if (!VersionUtil.atOrAbove("1.20.5") || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (ItemUtils.isEmpty(itemStack) || ItemUtils.isTool(itemStack)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof Damageable) || !(damageable = (Damageable)itemMeta).hasMaxDamage()) {
            return;
        }
        Optional.ofNullable(OraxenItems.getBuilderByItem(itemStack)).ifPresent(i -> {
            if (i.isDamagedOnBlockBreak()) {
                itemStack.damage(1, (LivingEntity)player);
            }
        });
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onUseMaxDamageItem(EntityDamageByEntityEvent event) {
        Damageable damageable;
        Player player;
        if (!VersionUtil.atOrAbove("1.20.5") || VersionUtil.atOrAbove("1.21.2")) {
            return;
        }
        Entity entity = event.getDamager();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ItemStack itemStack = Optional.ofNullable(entity2.getEquipment()).map(EntityEquipment::getItemInMainHand).orElse(null);
        if (entity2 instanceof Player && (player = (Player)entity2).getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (ItemUtils.isEmpty(itemStack) || ItemUtils.isTool(itemStack)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof Damageable) || !(damageable = (Damageable)itemMeta).hasMaxDamage()) {
            return;
        }
        Optional.ofNullable(OraxenItems.getBuilderByItem(itemStack)).ifPresent(i -> {
            if (i.isDamagedOnEntityHit()) {
                itemStack.damage(1, entity2);
            }
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onUseConvertedTo(PlayerItemConsumeEvent event) {
        ItemStack itemStack = event.getItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!VersionUtil.atOrAbove("1.21") && itemMeta == null) {
            return;
        }
        ItemStack usingConvertsTo = ItemUtils.getUsingConvertsTo(itemMeta);
        if (usingConvertsTo == null || !itemStack.isSimilar(ItemUpdater.updateItem(usingConvertsTo))) {
            return;
        }
        PlayerInventory inventory = event.getPlayer().getInventory();
        if (inventory.firstEmpty() == -1) {
            event.setItem(event.getItem().add(usingConvertsTo.getAmount()));
        } else {
            Bukkit.getScheduler().runTask((Plugin)OraxenPlugin.get(), () -> {
                for (int i = 0; i < inventory.getSize(); ++i) {
                    ItemStack oldItem = inventory.getItem(i);
                    ItemStack newItem = ItemUpdater.updateItem(oldItem);
                    if (!itemStack.isSimilar(newItem)) continue;
                    inventory.setItem(i, null);
                    inventory.addItem(new ItemStack[]{newItem});
                }
            });
        }
    }

    public static ItemStack updateItem(ItemStack oldItem) {
        String id = OraxenItems.getIdByItem(oldItem);
        if (id == null) {
            return oldItem;
        }
        ItemUtils.editItemMeta(oldItem, itemMeta -> {
            itemMeta.getPersistentDataContainer().remove(IF_UUID);
            itemMeta.getPersistentDataContainer().remove(MF_GUI);
        });
        Optional<ItemBuilder> optionalBuilder = OraxenItems.getOptionalItemById(id);
        if (optionalBuilder.isEmpty() || optionalBuilder.get().getOraxenMeta().isNoUpdate()) {
            return oldItem;
        }
        ItemBuilder newItemBuilder = optionalBuilder.get();
        ItemStack newItem = NMSHandlers.getHandler() != null ? NMSHandlers.getHandler().copyItemNBTTags(oldItem, newItemBuilder.build()) : newItemBuilder.build();
        newItem.setAmount(oldItem.getAmount());
        ItemUtils.editItemMeta(newItem, itemMeta -> {
            ItemMeta oldMeta = oldItem.getItemMeta();
            ItemMeta newMeta = newItem.getItemMeta();
            if (oldMeta == null || newMeta == null) {
                return;
            }
            PersistentDataContainer oldPdc = oldMeta.getPersistentDataContainer();
            PersistentDataContainer itemPdc = itemMeta.getPersistentDataContainer();
            List oldPdcMap = PersistentDataSerializer.toMapList((PersistentDataContainer)oldPdc);
            PersistentDataSerializer.fromMapList((List)oldPdcMap, (PersistentDataContainer)itemPdc);
            for (Map.Entry entry : oldMeta.getEnchants().entrySet()) {
                itemMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            for (Map.Entry entry : newMeta.getEnchants().entrySet().stream().filter(e -> !oldMeta.getEnchants().containsKey(e.getKey())).toList()) {
                itemMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
            }
            Integer cmd = newMeta.hasCustomModelData() ? Integer.valueOf(newMeta.getCustomModelData()) : (oldMeta.hasCustomModelData() ? Integer.valueOf(oldMeta.getCustomModelData()) : null);
            itemMeta.setCustomModelData(cmd);
            if (Settings.OVERRIDE_ITEM_LORE.toBool().booleanValue()) {
                if (VersionUtil.isPaperServer()) {
                    itemMeta.lore(newMeta.lore());
                } else {
                    itemMeta.setLore(newMeta.getLore());
                }
            } else if (VersionUtil.isPaperServer()) {
                itemMeta.lore(oldMeta.lore());
            } else {
                itemMeta.setLore(oldMeta.getLore());
            }
            if (newMeta.hasAttributeModifiers()) {
                itemMeta.setAttributeModifiers(newMeta.getAttributeModifiers());
            } else if (oldMeta.hasAttributeModifiers()) {
                itemMeta.setAttributeModifiers(oldMeta.getAttributeModifiers());
            }
            if (itemMeta instanceof Damageable) {
                Damageable oldDmg;
                Damageable damageable = (Damageable)itemMeta;
                if (oldMeta instanceof Damageable && (oldDmg = (Damageable)oldMeta).hasDamage()) {
                    damageable.setDamage(oldDmg.getDamage());
                }
            }
            if (oldMeta.isUnbreakable()) {
                itemMeta.setUnbreakable(true);
            }
            if (itemMeta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
                if (oldMeta instanceof LeatherArmorMeta) {
                    LeatherArmorMeta oldLeatherMeta = (LeatherArmorMeta)oldMeta;
                    if (newMeta instanceof LeatherArmorMeta) {
                        LeatherArmorMeta newLeatherMeta = (LeatherArmorMeta)newMeta;
                        if (oldItem.getType() == Material.LEATHER_HORSE_ARMOR) {
                            leatherArmorMeta.setColor(oldLeatherMeta.getColor());
                        } else {
                            leatherArmorMeta.setColor(newLeatherMeta.getColor());
                            newItemBuilder.save();
                        }
                    }
                }
            }
            if (itemMeta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)itemMeta;
                if (oldMeta instanceof PotionMeta) {
                    PotionMeta oldPotionMeta = (PotionMeta)oldMeta;
                    potionMeta.setColor(oldPotionMeta.getColor());
                }
            }
            if (itemMeta instanceof MapMeta) {
                MapMeta mapMeta = (MapMeta)itemMeta;
                if (oldMeta instanceof MapMeta) {
                    MapMeta oldMapMeta = (MapMeta)oldMeta;
                    mapMeta.setColor(oldMapMeta.getColor());
                }
            }
            if (VersionUtil.atOrAbove("1.20") && itemMeta instanceof ArmorMeta) {
                ArmorMeta armorMeta = (ArmorMeta)itemMeta;
                if (oldMeta instanceof ArmorMeta) {
                    ArmorMeta oldArmorMeta = (ArmorMeta)oldMeta;
                    armorMeta.setTrim(oldArmorMeta.getTrim());
                }
            }
            if (VersionUtil.atOrAbove("1.20.5")) {
                if (newMeta.hasFood()) {
                    itemMeta.setFood(newMeta.getFood());
                } else if (oldMeta.hasFood()) {
                    itemMeta.setFood(oldMeta.getFood());
                }
                if (newMeta.hasEnchantmentGlintOverride()) {
                    itemMeta.setEnchantmentGlintOverride(newMeta.getEnchantmentGlintOverride());
                } else if (oldMeta.hasEnchantmentGlintOverride()) {
                    itemMeta.setEnchantmentGlintOverride(oldMeta.getEnchantmentGlintOverride());
                }
                if (newMeta.hasMaxStackSize()) {
                    itemMeta.setMaxStackSize(Integer.valueOf(newMeta.getMaxStackSize()));
                } else if (oldMeta.hasMaxStackSize()) {
                    itemMeta.setMaxStackSize(Integer.valueOf(oldMeta.getMaxStackSize()));
                }
                if (VersionUtil.isPaperServer()) {
                    if (newMeta.hasItemName()) {
                        itemMeta.itemName(newMeta.itemName());
                    } else if (oldMeta.hasItemName()) {
                        itemMeta.itemName(oldMeta.itemName());
                    }
                } else if (newMeta.hasItemName()) {
                    itemMeta.setItemName(newMeta.getItemName());
                } else if (oldMeta.hasItemName()) {
                    itemMeta.setItemName(oldMeta.getItemName());
                }
            }
            if (VersionUtil.atOrAbove("1.21")) {
                if (newMeta.hasJukeboxPlayable()) {
                    itemMeta.setJukeboxPlayable(newMeta.getJukeboxPlayable());
                } else if (oldMeta.hasJukeboxPlayable()) {
                    itemMeta.setJukeboxPlayable(oldMeta.getJukeboxPlayable());
                }
            }
            if (VersionUtil.atOrAbove("1.21.2")) {
                if (newMeta.hasEquippable()) {
                    itemMeta.setEquippable(newMeta.getEquippable());
                } else if (oldMeta.hasEquippable()) {
                    itemMeta.setEquippable(newMeta.getEquippable());
                }
                if (newMeta.isGlider()) {
                    itemMeta.setGlider(true);
                } else if (oldMeta.isGlider()) {
                    itemMeta.setGlider(true);
                }
                if (newMeta.hasItemModel()) {
                    itemMeta.setItemModel(newMeta.getItemModel());
                } else if (oldMeta.hasItemModel()) {
                    itemMeta.setItemModel(oldMeta.getItemModel());
                }
                if (newMeta.hasUseCooldown()) {
                    itemMeta.setUseCooldown(newMeta.getUseCooldown());
                } else if (oldMeta.hasUseCooldown()) {
                    itemMeta.setUseCooldown(oldMeta.getUseCooldown());
                }
                if (newMeta.hasUseRemainder()) {
                    itemMeta.setUseRemainder(newMeta.getUseRemainder());
                } else if (oldMeta.hasUseRemainder()) {
                    itemMeta.setUseRemainder(oldMeta.getUseRemainder());
                }
                if (newMeta.hasDamageResistant()) {
                    itemMeta.setDamageResistant(newMeta.getDamageResistant());
                } else if (oldMeta.hasDamageResistant()) {
                    itemMeta.setDamageResistant(oldMeta.getDamageResistant());
                }
                if (newMeta.hasTooltipStyle()) {
                    itemMeta.setTooltipStyle(newMeta.getTooltipStyle());
                } else if (oldMeta.hasTooltipStyle()) {
                    itemMeta.setTooltipStyle(oldMeta.getTooltipStyle());
                }
                if (newMeta.hasEnchantable()) {
                    itemMeta.setEnchantable(Integer.valueOf(newMeta.getEnchantable()));
                } else if (oldMeta.hasEnchantable()) {
                    itemMeta.setEnchantable(Integer.valueOf(oldMeta.getEnchantable()));
                }
            }
            if (!VersionUtil.atOrAbove("1.20.5")) {
                String string = oldMeta.hasDisplayName() ? AdventureUtils.parseLegacy(VersionUtil.isPaperServer() ? (String)AdventureUtils.MINI_MESSAGE.serialize(oldMeta.displayName()) : AdventureUtils.parseLegacy(oldMeta.getDisplayName())) : null;
                String originalName = AdventureUtils.parseLegacy((String)oldPdc.getOrDefault(ItemBuilder.ORIGINAL_NAME_KEY, DataType.STRING, (Object)""));
                if (Settings.OVERRIDE_RENAMED_ITEMS.toBool().booleanValue()) {
                    if (VersionUtil.isPaperServer()) {
                        itemMeta.displayName(newMeta.displayName());
                    } else {
                        itemMeta.setDisplayName(newMeta.getDisplayName());
                    }
                } else if (!originalName.equals(string)) {
                    if (VersionUtil.isPaperServer()) {
                        itemMeta.displayName(oldMeta.displayName());
                    } else {
                        itemMeta.setDisplayName(oldMeta.getDisplayName());
                    }
                } else if (VersionUtil.isPaperServer()) {
                    itemMeta.displayName(newMeta.displayName());
                } else {
                    itemMeta.setDisplayName(newMeta.getDisplayName());
                }
                String string2 = newMeta.hasDisplayName() ? (VersionUtil.isPaperServer() ? (String)AdventureUtils.MINI_MESSAGE.serialize(newMeta.displayName()) : newMeta.getDisplayName()) : (originalName = null);
                if (originalName != null) {
                    itemPdc.set(ItemBuilder.ORIGINAL_NAME_KEY, DataType.STRING, (Object)originalName);
                }
            } else if (newMeta.hasDisplayName() && !newMeta.getDisplayName().isEmpty()) {
                if (VersionUtil.isPaperServer()) {
                    itemMeta.displayName(newMeta.displayName());
                } else {
                    itemMeta.setDisplayName(newMeta.getDisplayName());
                }
            } else if (VersionUtil.isPaperServer()) {
                itemMeta.displayName(oldMeta.displayName());
            } else {
                itemMeta.setDisplayName(oldMeta.getDisplayName());
            }
            if (VersionUtil.atOrAbove("1.20.5") || !newItemBuilder.isUnstackable()) {
                itemPdc.remove(ItemBuilder.UNSTACKABLE_KEY);
            } else {
                itemPdc.set(ItemBuilder.UNSTACKABLE_KEY, DataType.UUID, (Object)UUID.randomUUID());
            }
        });
        Optional.ofNullable(NMSHandlers.getHandler()).ifPresent(nmsHandler -> nmsHandler.consumableComponent(newItem, Optional.ofNullable(nmsHandler.consumableComponent(newItem)).orElse(nmsHandler.consumableComponent(oldItem))));
        return newItem;
    }
}

